/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactory;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.geo.model.GeoContainerElement;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.object.ContainerElement;
import java.util.Collection;

public class GeoElementNodeFactory
extends NodeFactory {
    private static boolean isGeo(Collection<PropertyValue> properties) {
        if (properties != null) {
            for (PropertyValue property : properties) {
                if (property.getProperty() != GeoPropertyDescriptors.IS_GEO || !Boolean.TRUE.equals(property.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public GeoElementNodeFactory() {
        this.registerType(ElementTypes.ELEMENT_CONTAINER, GeoContainerElement::new);
    }

    public INode create(TypeDescriptor type, Long id, Collection<PropertyValue> properties, IRepository repository) {
        if (type == ElementTypes.ELEMENT_CONTAINER) {
            if (GeoElementNodeFactory.isGeo(properties)) {
                return new GeoContainerElement(id, properties, repository);
            }
            return new ContainerElement(id, properties, repository);
        }
        return null;
    }
}

