/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.media.model.MediaRepositoryDecorator;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.MediaWizardPage;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.model.GeoElementPropertiesWizardPage;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;
import com.centreon.studio.map.client.elements.messages.ElementMessages;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.wizards.ResourceWizardPage;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum GeoWizardFactory implements IWizardFactory
{
    INSTANCE;

    private static final Set<TypeDescriptor> SUPPORTED_TYPES;

    static {
        SUPPORTED_TYPES = new HashSet<TypeDescriptor>(4);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_HOST);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_SHAPE);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_CONTAINER);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_HOST_GROUP);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_MEDIA_IMAGE);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_SERVICE_GROUP);
    }

    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        if (input == null) {
            return null;
        }
        ResourceRepositoryDecorator resourceRepositoryDecorator = (ResourceRepositoryDecorator)ContextInjectionFactory.make(ResourceRepositoryDecorator.class, (IEclipseContext)context);
        RepositoryDecorator elementRepositoryDecorator = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        MapBoxProvider provider = (MapBoxProvider)ContextInjectionFactory.make(MapBoxProvider.class, (IEclipseContext)context);
        MediaRepositoryDecorator mediaRepository = (MediaRepositoryDecorator)ContextInjectionFactory.make(MediaRepositoryDecorator.class, (IEclipseContext)context);
        ACLUser user = (ACLUser)ContextUtils.getTopContext((IEclipseContext)context).get(ACLUser.class);
        boolean enableGeo = user != null && !StringUtils.isNullEmptyOrBlank((String)((String)user.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN)));
        CustomWizard wizard = new CustomWizard(ElementMessages.elementWizardLabel);
        wizard.registerPage((CustomWizardPage)new GeoElementPropertiesWizardPage(provider, enableGeo));
        if (input.getTarget().getType() != ElementTypes.ELEMENT_MEDIA_IMAGE && ElementTypes.getAllResourceElements().contains(input.getTarget().getType())) {
            TypeDescriptor resourceType = (TypeDescriptor)input.getTarget().getProperty(ElementPropertyDescriptors.RESOURCE_TYPE);
            wizard.registerPage((CustomWizardPage)new ResourceWizardPage((INode)resourceRepositoryDecorator, elementRepositoryDecorator, Arrays.asList(resourceType), "Resource", null, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION, ResourceTypes.RESOURCE_RELATION_LEAF}));
        }
        if (input.getTarget().getType() != ElementTypes.ELEMENT_SHAPE) {
            wizard.registerPage((CustomWizardPage)new MediaWizardPage((IRepository)mediaRepository, Arrays.asList(MediaTypes.MEDIA_IMAGE)));
        }
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }
}

