/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model.ui.actions;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import java.util.Arrays;

public abstract class APositionAction
extends AACLRepositoryAction {
    protected APositionAction(String text, IRepository repository) {
        super(text, repository);
        this.setSelectionSingleAccepted(true);
        this.setACLRightNeeded(ACLPropertyDescriptors.CAN_UPDATE);
        this.addSupportedTypes(Arrays.asList(ElementTypes.ELEMENT_CONTAINER));
    }

    public boolean customIsEnabled() {
        Boolean isGeo = (Boolean)this.getInput().getSelection().getTarget().getProperty(GeoPropertyDescriptors.IS_GEO);
        if (!isGeo.booleanValue()) {
            return false;
        }
        INodeRelation relation = this.getInput().getSelection();
        LatLng latLng = (LatLng)relation.getProperty(ElementPropertyDescriptors.LATLNG);
        LatLng curlatLng = (LatLng)relation.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
        INode target = relation.getTarget();
        Double zoom = (Double)target.getProperty(PropertyDescriptors.ZOOM);
        Double curzoom = (Double)target.getProperty(PropertyDescriptors.CURRENT_ZOOM);
        return !curlatLng.equals((Object)latLng) || !curzoom.equals(zoom);
    }
}

