/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.tiles;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;
import com.centreon.studio.map.client.elements.geo.tiles.TileDescription;
import java.util.Collection;
import java.util.HashSet;

public class TilesUtils {
    public static final TileDescription posToTileDescription(Pos pos, int z, StyleDescription style) {
        return new TileDescription(z, TilesUtils.posToTileIndex(pos.x.intValue()), TilesUtils.posToTileIndex(pos.y.intValue()), style);
    }

    public static Collection<TileDescription> tilesAround(TileDescription centerTile, int w, int h) {
        HashSet<TileDescription> set = new HashSet<TileDescription>(2 * w + 1 + 2 * h + 1);
        int x = 0;
        while (x < w + 1) {
            int y = 0;
            while (y < h + 1) {
                set.add(new TileDescription(centerTile.z, centerTile.x + x, centerTile.y + y, centerTile.style));
                set.add(new TileDescription(centerTile.z, centerTile.x - x, centerTile.y + y, centerTile.style));
                set.add(new TileDescription(centerTile.z, centerTile.x + x, centerTile.y - y, centerTile.style));
                set.add(new TileDescription(centerTile.z, centerTile.x - x, centerTile.y - y, centerTile.style));
                ++y;
            }
            ++x;
        }
        return set;
    }

    private static int posToTileIndex(int x) {
        int mx = x % 512;
        return (x - mx) / 512;
    }

    private TilesUtils() {
    }
}

