/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.ObjectIdentifier;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.preference.model.PreferenceTypes;
import com.centreon.studio.client.preference.model.PreferenceWebService;
import com.centreon.studio.client.utils.StepTimeTracker;
import java.util.Arrays;
import java.util.HashSet;

public class PreferenceSyncEventHandler
extends SyncEventHandler {
    private static final String TARGET_TYPE = "targetType";
    private final BrokerEventManager eventManager;
    private final PreferenceWebService preferenceWebService;

    public PreferenceSyncEventHandler(PreferenceWebService preferenceWebService, BrokerEventManager eventManager) {
        super(Arrays.asList(PreferenceTypes.PREFERENCE.getId()));
        this.preferenceWebService = preferenceWebService;
        this.eventManager = eventManager;
    }

    public void handleEvent(SyncEvent event) {
        StepTimeTracker counter = new StepTimeTracker(PreferenceSyncEventHandler.class.getSimpleName());
        HashSet<IObject> identifiers = new HashSet<IObject>(event.getData().size());
        for (SyncEvent.SyncData data : event.getData()) {
            int targetTypeId = Integer.parseInt(data.getProperty(TARGET_TYPE).toString());
            identifiers.add((IObject)new ObjectIdentifier(data.getId().longValue(), TypeDescriptor.getType((Integer)targetTypeId)));
        }
        this.preferenceWebService.loadScopes(identifiers);
        this.eventManager.async((StudioEvent)LogEvent.trace(PreferenceSyncEventHandler.class, (String)counter.finish(), (Object[])new Object[0]));
    }
}

