/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.model;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.preference.PreferenceEvent;
import com.centreon.studio.client.preference.model.PreferenceWebService;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PreferenceSaveRepositoryStrategy
extends ARepositoryStrategy {
    private Collection<INode> modifiedScopes = new HashSet<INode>(1);
    private PreferenceWebService service;
    private BrokerEventManager eventManager;

    @Inject
    public PreferenceSaveRepositoryStrategy(PreferenceWebService service, BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.service = service;
    }

    public void addPropertyValues(ObjectDecorator decorator, Collection<PropertyValue> propertyValues) {
        NodeDecorator nodeDecorator = (NodeDecorator)decorator.adapt(NodeDecorator.class);
        if (nodeDecorator == null) {
            return;
        }
        this.addToModifiedScopes(nodeDecorator);
    }

    public void addRelations(NodeDecorator nodeDecorator, Collection<INodeRelation> relations) {
        this.addToModifiedScopes(nodeDecorator);
    }

    private void addToModifiedScopes(NodeDecorator nodeDecorator) {
        INode scope = (INode)nodeDecorator.getProperty(PropertyDescriptors.SCOPE);
        this.modifiedScopes.add((INode)(scope != null ? scope : nodeDecorator));
    }

    public void removeRelations(NodeDecorator nodeDecorator, Collection<INodeRelation> relations) {
        this.addToModifiedScopes(nodeDecorator);
    }

    public void save() {
        if (!this.modifiedScopes.isEmpty()) {
            for (INode modifiedScope : this.modifiedScopes) {
                if (!this.service.saveScope(modifiedScope)) continue;
                this.eventManager.async((StudioEvent)new PreferenceEvent(modifiedScope));
            }
            this.modifiedScopes.clear();
        }
    }
}

