/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.object;

import com.centreon.studio.client.model.decoration.repository.IRepositoryStrategy;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;

public class ObjectDecorator
implements IObject,
IPropertiesListener {
    private final IObject decorated;
    private final RepositoryDecorator repository;
    private Collection<IPropertiesListener> listeners;

    public ObjectDecorator(IObject decorated, RepositoryDecorator repository) {
        Assert.isNotNull((Object)decorated, (String)"decorated must not be null");
        this.decorated = decorated;
        this.repository = repository;
        this.decorated.registerPropertiesListener((IPropertiesListener)this);
    }

    public <A> A adapt(Class<A> clazz) {
        Object a = this.decorated.adapt(clazz);
        if (a != null) {
            return (A)a;
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return (A)this;
        }
        if (clazz == RepositoryDecorator.class) {
            return (A)this.repository;
        }
        return null;
    }

    public final <T> void addPropertyValue(PropertyDescriptor<T> descriptor, T value) {
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(1);
        list.add(new PropertyValue(descriptor, value));
        this.addPropertyValues(list);
    }

    public final void addPropertyValues(Collection<PropertyValue> propertyValues) {
        if (propertyValues == null || propertyValues.isEmpty()) {
            return;
        }
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.addPropertyValues(this, propertyValues);
        }
        this.getDecorated().addPropertyValues(propertyValues);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.decorated.equals(obj);
    }

    public final Collection<PropertyValue> getDefaultPropertyValues() {
        return this.decorated.getDefaultPropertyValues();
    }

    public Long getId() {
        return this.decorated.getId();
    }

    public final String getLabel() {
        return this.decorated.getLabel();
    }

    public final <T> T getProperty(PropertyDescriptor<T> property) {
        Object value = this.decorated.getProperty(property);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            T strategyValue = strategy.getProperty(this, property);
            if (strategyValue == null) continue;
            value = strategyValue;
        }
        return (T)value;
    }

    public Collection<PropertyValue> getPropertyValues() {
        Collection values = this.decorated.getPropertyValues();
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.getPropertyValues(this, values);
        }
        return values;
    }

    public RepositoryDecorator getRepository() {
        return this.repository;
    }

    public TypeDescriptor getType() {
        return this.decorated.getType();
    }

    public final int hashCode() {
        return this.decorated.hashCode();
    }

    public final void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        if (propertyValues == null || propertyValues.isEmpty()) {
            return;
        }
        ArrayList<PropertyValue> modifiedValues = new ArrayList<PropertyValue>(propertyValues);
        for (IRepositoryStrategy strategy : this.getRepository().getStrategies()) {
            strategy.propertiesChanged(this, modifiedValues);
        }
        this.sendEvent(modifiedValues);
    }

    public final void registerPropertiesListener(IPropertiesListener objectListener) {
        if (objectListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IPropertiesListener>();
        }
        this.listeners.add(objectListener);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [decorated=");
        builder.append(this.decorated);
        builder.append("]");
        return builder.toString();
    }

    public final void unregisterPropertiesListener(IPropertiesListener objectListener) {
        if (this.listeners == null || objectListener == null) {
            return;
        }
        this.listeners.remove(objectListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected IObject getDecorated() {
        return this.decorated;
    }

    private void sendEvent(Collection<PropertyValue> propertyValues) {
        if (this.listeners != null) {
            for (IPropertiesListener listener : this.listeners) {
                listener.propertiesChanged((IObject)this, propertyValues);
            }
        }
    }
}

