/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.repository;

import com.centreon.studio.client.model.decoration.IIndexer;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.repository.IRepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.utils.CollectionsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RepositoryDecorator
extends NodeDecorator
implements IRepository,
IRepositoryListener {
    private final List<INodeRelation> selection;
    private final List<IRepositoryStrategy> strategies;
    private Collection<IRepositoryListener> listeners;

    public RepositoryDecorator(IRepository repository, IRepositoryStrategy ... strategies) {
        this(repository, new ArrayList<IRepositoryStrategy>(Arrays.asList(strategies)));
    }

    private RepositoryDecorator(IRepository repository, List<IRepositoryStrategy> strategies) {
        super((INode)repository, null);
        this.strategies = strategies;
        this.selection = CollectionsUtils.createList((int)1);
        this.init();
    }

    public final void appendToSelection(Object source, Collection<? extends INodeRelation> selection) {
        Collection<INodeRelation> undecoratedSelection = NodeDecorator.undecorate(selection);
        for (IRepositoryStrategy strategy : this.strategies) {
            strategy.appendToSelection(this, source, undecoratedSelection);
        }
        this.getDecorated().appendToSelection(source, undecoratedSelection);
    }

    @Override
    public final RepositoryDecorator getRepository() {
        return this;
    }

    public final INodeRelation getSelection() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public final List<INodeRelation> getSelections() {
        return Collections.unmodifiableList(this.selection);
    }

    public List<IRepositoryStrategy> getStrategies() {
        return this.strategies;
    }

    public void registerSelectionListener(IRepositoryListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IRepositoryListener>();
        }
        this.listeners.add(listener);
    }

    public final void removeFromSelection(Collection<? extends INodeRelation> selection) {
        Collection<INodeRelation> undecoratedSelection = NodeDecorator.undecorate(selection);
        for (IRepositoryStrategy strategy : this.strategies) {
            strategy.removeFromSelection(this, undecoratedSelection);
        }
        this.getDecorated().removeFromSelection(undecoratedSelection);
    }

    public final void selectionChanged(Object source, IRepository repository) {
        this.selection.clear();
        IIndexer index = this.adapt(IIndexer.class);
        for (INodeRelation selected : repository.getSelections()) {
            INodeRelation decorated = index != null ? index.getRelation(selected.getType(), selected.getId()) : INodeUtils.findRelation((INode)this, (Long)selected.getId(), (TypeDescriptor[])new TypeDescriptor[]{selected.getType()});
            if (decorated == null) continue;
            this.selection.add(decorated);
        }
        for (IRepositoryStrategy strategy : this.strategies) {
            strategy.selectionChanged(this, source);
        }
        this.sendEvent(source);
    }

    public final void setSelection(Object source, Collection<? extends INodeRelation> selection) {
        Collection<INodeRelation> undecoratedSelection = NodeDecorator.undecorate(selection);
        for (IRepositoryStrategy strategy : this.strategies) {
            strategy.setSelection(this, source, undecoratedSelection);
        }
        this.getDecorated().setSelection(source, undecoratedSelection);
    }

    public void unregisterSelectionListener(IRepositoryListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected final IRepository getDecorated() {
        return (IRepository)super.getDecorated();
    }

    @Override
    protected void init() {
        super.init();
        if (this.selection == null) {
            return;
        }
        if (!this.getDecorated().getSelections().isEmpty()) {
            this.selectionChanged(null, this.getDecorated());
        }
        this.getDecorated().registerSelectionListener((IRepositoryListener)this);
    }

    protected final void removeStrategy(IRepositoryStrategy strategy) {
        this.strategies.remove(strategy);
    }

    private void sendEvent(Object source) {
        if (this.listeners != null) {
            for (IRepositoryListener listener : this.listeners) {
                listener.selectionChanged(source, (IRepository)this);
            }
        }
    }
}

