/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl.ui;

import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class MultipleCheckboxComposite {
    private final String label;
    private final long idToTest;
    private final TypeDescriptor typeToTest;
    private final Map<PropertyDescriptor<Boolean>, Button> buttons = new HashMap<PropertyDescriptor<Boolean>, Button>(4);
    private final Map<INode, Map<PropertyDescriptor<Boolean>, Boolean>> resultMap = new HashMap<INode, Map<PropertyDescriptor<Boolean>, Boolean>>(10);
    private final Collection<DependencyListener> dependencyListeners = new ArrayList<DependencyListener>(5);
    private final List<PropertyDescriptor<Boolean>> propertyDescriptors;
    private INode aclGroup;
    private Label labelSwt;
    private Composite composite;

    public MultipleCheckboxComposite(String label, long idToTest, TypeDescriptor typeToTest, List<PropertyDescriptor<Boolean>> propertyDescriptors) {
        this.idToTest = idToTest;
        this.typeToTest = typeToTest;
        this.label = label;
        this.propertyDescriptors = propertyDescriptors;
    }

    public final void addDependencyListener(PropertyDescriptor<Boolean> trigger, PropertyDescriptor<Boolean> listener, boolean onSelect, boolean onUnselect) {
        DependencyListener dl = new DependencyListener(trigger, listener, onSelect, onUnselect);
        this.dependencyListeners.add(dl);
    }

    public final void addListenner(Button button, final PropertyDescriptor<Boolean> pd) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)MultipleCheckboxComposite.this.buttons.get(pd);
                if (b == null || !b.isVisible()) {
                    return;
                }
                ((Button)MultipleCheckboxComposite.this.buttons.get(pd)).setSelection(((Button)e.widget).getSelection());
            }
        });
    }

    public final void fillComposite(Composite composite) {
        this.composite = composite;
        this.labelSwt = SWTUtils.createLabel((Composite)composite, (String)this.label);
        GridData gd = SWTUtils.createGridDataHorizontalFill();
        gd.exclude = false;
        this.labelSwt.setLayoutData((Object)gd);
        for (PropertyDescriptor<Boolean> propertyDescriptor : this.propertyDescriptors) {
            this.createNewButton(composite, propertyDescriptor);
        }
        this.updateValues();
        this.registerDependencyListeners();
    }

    public final INode getAclGroup() {
        return this.aclGroup;
    }

    public final long getIdToTest() {
        return this.idToTest;
    }

    public final String getLabel() {
        return this.label;
    }

    public final Map<INode, Map<PropertyDescriptor<Boolean>, Boolean>> getResults() {
        this.saveValues();
        return Collections.unmodifiableMap(this.resultMap);
    }

    public final void setAclGroup(INode aclGroup) {
        this.saveValues();
        this.aclGroup = aclGroup;
        this.setEnabled(this.aclGroup != null);
        this.updateValues();
    }

    public final void setVisible(boolean visible) {
        this.buttons.values().stream().forEach(b -> {
            ((GridData)b.getLayoutData()).exclude = !visible;
            b.setVisible(visible);
        });
        ((GridData)this.labelSwt.getLayoutData()).exclude = !visible;
        this.labelSwt.setVisible(visible);
        if (this.composite != null) {
            this.composite.layout();
        }
    }

    private void createNewButton(Composite composite, PropertyDescriptor<Boolean> pd) {
        Button checkButton = SWTUtils.createButton((Composite)composite, (int)32, (String)"", (GridData)SWTUtils.createGridData((int)0x1000000, (int)0x1000000, (int)-1, (int)-1), null);
        GridData gd = SWTUtils.createGridData((int)0x1000000, (int)0x1000000, (int)-1, (int)-1);
        gd.exclude = false;
        checkButton.setLayoutData((Object)gd);
        this.buttons.put(pd, checkButton);
    }

    private void registerDependencyListeners() {
        for (final DependencyListener dl : this.dependencyListeners) {
            Button triggerButton = this.buttons.get(dl.trigger);
            final Button listenerButton = this.buttons.get(dl.target);
            if (triggerButton == null || listenerButton == null) {
                return;
            }
            triggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    if (isSelected && dl.onSelect) {
                        listenerButton.setSelection(true);
                    } else if (!isSelected && dl.onUnselect) {
                        listenerButton.setSelection(false);
                    }
                }
            });
        }
    }

    private void saveValues() {
        if (this.aclGroup != null) {
            Map<PropertyDescriptor<Boolean>, Boolean> valuesForAclGroup = this.resultMap.get(this.aclGroup.getId());
            if (valuesForAclGroup == null) {
                valuesForAclGroup = new HashMap<PropertyDescriptor<Boolean>, Boolean>(this.buttons.size());
                this.resultMap.put(this.aclGroup, valuesForAclGroup);
            }
            for (Map.Entry<PropertyDescriptor<Boolean>, Button> entry : this.buttons.entrySet()) {
                valuesForAclGroup.put(entry.getKey(), entry.getValue().getSelection());
            }
        }
    }

    private void setEnabled(boolean enabled) {
        this.buttons.values().stream().forEach(b -> b.setEnabled(enabled));
    }

    private void updateValues() {
        Map<PropertyDescriptor<Boolean>, Boolean> currentValues = this.resultMap.get(this.aclGroup);
        if (currentValues != null) {
            for (Map.Entry<PropertyDescriptor<Boolean>, Boolean> entry : currentValues.entrySet()) {
                this.buttons.get(entry.getKey()).setSelection(entry.getValue().booleanValue());
            }
            return;
        }
        for (Map.Entry<PropertyDescriptor<Boolean>, Button> entry : this.buttons.entrySet()) {
            boolean canDoAction = ACLUtils.can((INode)this.aclGroup, entry.getKey(), (TypeDescriptor)this.typeToTest, (Long)this.idToTest, (boolean)false);
            entry.getValue().setSelection(canDoAction);
        }
    }

    private final class DependencyListener {
        public final PropertyDescriptor<Boolean> target;
        public final PropertyDescriptor<Boolean> trigger;
        public final boolean onSelect;
        public final boolean onUnselect;

        protected DependencyListener(PropertyDescriptor<Boolean> trigger, PropertyDescriptor<Boolean> target, boolean onSelect, boolean onUnselect) {
            this.trigger = trigger;
            this.target = target;
            this.onSelect = onSelect;
            this.onUnselect = onUnselect;
        }
    }
}

