/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.editparts;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.gef.editparts.INodeEditPart;
import com.centreon.studio.client.gef.editpolicies.NodeHoverEditPolicy;
import com.centreon.studio.client.gef.figures.INodeFigure;
import com.centreon.studio.client.model.AlignmentHorizontal;
import com.centreon.studio.client.model.AlignmentVertical;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;

public abstract class ANodeRelationGraphicalEditPart
extends AbstractGraphicalEditPart
implements INodeEditPart,
NodeEditPart,
INodeRelationListener,
IPropertiesListener {
    private ConnectionAnchor sourceAnchor;
    private ConnectionAnchor targetAnchor;
    protected boolean activated;

    protected ANodeRelationGraphicalEditPart(INodeRelation relation) {
        super.setModel((Object)relation);
    }

    public void activate() {
        super.activate();
        if (!this.activated) {
            this.getModel().registerPropertiesListener((IPropertiesListener)this);
            this.getModel().getTarget().registerRelationsListener((INodeRelationListener)this);
            this.getModel().getTarget().registerPropertiesListener((IPropertiesListener)this);
            this.activated = true;
        }
    }

    public void deactivate() {
        List l = this.getTargetConnections();
        int i = 0;
        while (i < l.size()) {
            ConnectionEditPart part = (ConnectionEditPart)l.get(i);
            if (part != null && part.getSource() != null) {
                part.getSource().refresh();
            }
            ++i;
        }
        super.deactivate();
        if (this.activated) {
            this.getModel().unregisterPropertiesListener((IPropertiesListener)this);
            this.getModel().getTarget().unregisterRelationsListener((INodeRelationListener)this);
            this.getModel().getTarget().unregisterPropertiesListener((IPropertiesListener)this);
            this.activated = false;
        }
    }

    @Override
    public INodeFigure getFigure() {
        return (INodeFigure)super.getFigure();
    }

    @Override
    public INodeRelation getModel() {
        return (INodeRelation)super.getModel();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getSourceConnectionAnchor((Request)null);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = this.createAnchor();
        }
        return this.sourceAnchor;
    }

    public final ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getTargetConnectionAnchor((Request)null);
    }

    public final ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (this.targetAnchor == null) {
            this.targetAnchor = this.createAnchor();
        }
        return this.targetAnchor;
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        this.refreshVisuals();
        for (PropertyValue pv : propertyValues) {
            if (pv.getProperty() == PropertyDescriptors.LAYER) {
                this.changedLayer(pv);
                continue;
            }
            if (pv.getProperty() != PropertyDescriptors.STYLE) continue;
            ((INodeEditPart)this.getParent()).removeChild((EditPart)this);
        }
    }

    @Override
    public void refreshConnections() {
        SWTUtils.getDisplay().syncExec(() -> {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        });
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getType() != StudioTypes.RELATION_LINK) continue;
            this.refreshVisuals();
            return;
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getType() != StudioTypes.RELATION_LINK) continue;
            this.refreshVisuals();
            return;
        }
    }

    @Override
    public void removeChild(EditPart child) {
        super.removeChild(child);
    }

    public void setModel(Object model) {
        throw new UnsupportedOperationException("model must be set at constructor time");
    }

    public void setSelected(int value) {
        super.setSelected(value);
        this.getFigure().select(value);
    }

    protected ConnectionAnchor createAnchor() {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    protected void createEditPolicies() {
        this.installEditPolicy(NodeHoverEditPolicy.class, (EditPolicy)new NodeHoverEditPolicy());
    }

    protected void refreshVisuals() {
        SWTUtils.getDisplay().syncExec(() -> {
            Pos dimension = (Pos)this.getModel().getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            Pos position = (Pos)this.getModel().getProperty(PropertyDescriptors.CURRENT_POSITION);
            INodeFigure figure = this.getFigure();
            figure.setSize(dimension.x.intValue(), dimension.y.intValue());
            figure.setLocation(new Point(position.x.intValue(), position.y.intValue()));
            INode target = this.getModel().getTarget();
            StudioFont studioFont = (StudioFont)target.getProperty(PropertyDescriptors.FONT);
            Font swtFont = StudioRegistries.fontRegistry().getSWTFontFrom(studioFont);
            figure.setFont(swtFont);
            figure.setAlpha((Integer)target.getProperty(PropertyDescriptors.ALPHA));
            figure.setOpaque((Boolean)target.getProperty(PropertyDescriptors.OPAQUE));
            figure.setEnabled((Boolean)target.getProperty(PropertyDescriptors.ACTIVE));
            StudioColor color = (StudioColor)target.getProperty(PropertyDescriptors.COLOR);
            figure.setBackgroundColor(StudioRegistries.colorRegistry().getSWTColorFrom(color));
            StudioColor fontColor = (StudioColor)target.getProperty(PropertyDescriptors.FONT_COLOR);
            figure.setForegroundColor(StudioRegistries.colorRegistry().getSWTColorFrom(fontColor));
            figure.setVerticalAlignment(((AlignmentVertical)target.getProperty(PropertyDescriptors.VERTICAL_ALIGNMENT)).getId());
            figure.setHorizontalAlignment(((AlignmentHorizontal)target.getProperty(PropertyDescriptors.HORIZONTAL_ALIGNMENT)).getId());
            String label = (Boolean)target.getProperty(PropertyDescriptors.DISPLAY_LABEL) != false ? target.getLabel() : "";
            figure.setLabel(label);
        });
    }

    private void changedLayer(PropertyValue pv) {
        IFigure newLayer;
        String newLayerName = (String)pv.getValue();
        if (newLayerName == null) {
            newLayerName = (String)PropertyDescriptors.LAYER.defaulValue;
        }
        if ((newLayer = this.getLayer(newLayerName)) == null) {
            newLayer = this.getLayer(PropertyDescriptors.LAYER.defaulValue);
        }
        if (newLayer != null) {
            this.getFigure().getParent().remove((IFigure)this.getFigure());
            newLayer.add((IFigure)this.getFigure());
            this.getRoot().refresh();
        }
    }
}

