/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.figures;

import com.centreon.studio.client.gef.figures.INodeFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class NodeFigure
extends Figure
implements INodeFigure {
    public static final int MARGE = 5;
    private final RoundedRectangle hoverShape;
    private boolean selected = false;
    private boolean hovered = false;

    public NodeFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.hoverShape = new RoundedRectangle();
        this.hoverShape.setCornerDimensions(new Dimension(5, 5));
        this.hoverShape.setVisible(false);
        this.hoverShape.setAlpha(30);
        this.add((IFigure)this.hoverShape);
    }

    public void add(IFigure figure, Object constraint, int index) {
        int actualIndex = index;
        if (actualIndex == -1) {
            actualIndex += this.getChildren().size();
        }
        super.add(figure, constraint, actualIndex);
    }

    @Override
    public void hover(boolean hovered) {
        this.hovered = hovered;
        if (!this.isSelected()) {
            this.hoverShape.setForegroundColor(ColorConstants.blue);
            this.hoverShape.setBackgroundColor(ColorConstants.menuBackground);
            this.hoverShape.setVisible(this.isHovered());
        }
    }

    @Override
    public void select(int value) {
        boolean bl = this.selected = value > 0;
        if (this.isSelected()) {
            this.hoverShape.setForegroundColor(ColorConstants.blue);
            this.hoverShape.setBackgroundColor(ColorConstants.menuBackgroundSelected);
        } else if (this.isHovered()) {
            this.hoverShape.setForegroundColor(ColorConstants.blue);
            this.hoverShape.setBackgroundColor(ColorConstants.menuBackground);
        }
        this.hoverShape.setVisible(this.isSelected() || this.isHovered());
    }

    @Override
    public void setAlpha(int alpha) {
    }

    public void setBounds(Rectangle rect) {
        rect.x -= rect.width / 2;
        rect.y -= rect.height / 2;
        this.hoverShape.setSize(rect.width, rect.height);
        super.setBounds(rect);
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public void setVerticalAlignment(int alignment) {
    }

    protected final boolean isSelected() {
        return this.selected;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.setTextAntialias(1);
        graphics.setAntialias(1);
        graphics.setAdvanced(true);
        super.paintClientArea(graphics);
    }

    protected final boolean useLocalCoordinates() {
        return true;
    }

    private final boolean isHovered() {
        return this.hovered;
    }
}

