/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.gef.palette;

import com.centreon.studio.client.gef.editparts.CustomScalableFreeformRootEditPart;
import com.centreon.studio.client.gef.palette.ContextCreationTool;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.Objects;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class MultiInputTool
extends ContextCreationTool {
    private final Polyline figure;

    private static Point getOrigin(PointList points) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int i = 0;
        while (i < points.size()) {
            Point p = points.getPoint(i);
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            ++i;
        }
        return new Point(minX, minY);
    }

    public MultiInputTool() {
        this.setDefaultCursor(Cursors.HAND);
        this.figure = new Polyline();
    }

    public void deactivate() {
        super.deactivate();
        if (this.getState() == 0x40000000 && this.figure.getParent() != null && this.getCurrentViewer() != null) {
            this.removeFeedback((IFigure)this.figure);
        }
    }

    protected String getCommandName() {
        return "multi input tool";
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        this.lockTargetEditPart(this.getTargetEditPart());
        this.addpoint();
        return super.handleButtonDown(button);
    }

    protected boolean handleButtonUp(int button) {
        if (this.finished(this.figure.getPoints().getLastPoint())) {
            return super.handleButtonUp(button);
        }
        return true;
    }

    protected boolean handleDoubleClick(int button) {
        this.addpoint();
        this.figure.getPoints().addPoint(this.figure.getPoints().getFirstPoint());
        return super.handleDoubleClick(button);
    }

    protected void handleFinished() {
        this.lockTargetEditPart(this.getTargetEditPart());
        this.removeFeedback((IFigure)this.figure);
        super.handleFinished();
    }

    protected boolean handleMove() {
        if (this.figure.getPoints().size() != 0) {
            this.drawLine();
            this.addFeedback((IFigure)this.figure);
        }
        return super.handleMove();
    }

    protected void showTargetFeedback() {
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        Point adjustement = this.getAdjustement();
        Point origin = MultiInputTool.getOrigin(this.figure.getPoints());
        PointList copy = new PointList();
        Point last = null;
        int i = 0;
        while (i < this.figure.getPoints().size()) {
            Point p = this.figure.getPoints().getPoint(i);
            if (!Objects.equals(last, p)) {
                last = p;
                copy.addPoint(p);
            }
            ++i;
        }
        copy.translate(-origin.x, -origin.y);
        this.getTargetRequest().getExtendedData().put(PointList.class, copy);
        if (this.figure.getPoints().size() != 0) {
            this.getCreateRequest().setLocation(origin.getTranslated(-adjustement.x, -adjustement.y));
            this.getCreateRequest().setSize(new Dimension(this.figure.getPoints().getBounds().width, this.figure.getPoints().getBounds().height));
            this.getCreateRequest().setSnapToEnabled(true);
        }
    }

    private void addpoint() {
        Point adjustement = this.getAdjustement();
        this.figure.addPoint(this.getLocation().getTranslated(adjustement));
    }

    private void drawLine() {
        Point adjustement = this.getAdjustement();
        if (this.figure.getPoints().size() > 0) {
            if (this.getCurrentInput().isShiftKeyDown()) {
                Point point;
                Point point2 = point = this.figure.getPoints().size() > 1 ? this.figure.getPoints().getPoint(this.figure.getPoints().size() - 2) : this.figure.getPoints().getFirstPoint();
                if (Math.abs(this.getLocation().x - point.x) < Math.abs(this.getLocation().y - point.y)) {
                    this.figure.setEnd(new Point(point.x, this.getLocation().y + adjustement.y));
                } else {
                    this.figure.setEnd(new Point(this.getLocation().x + adjustement.x, point.y));
                }
            } else {
                this.figure.setEnd(new Point(this.getLocation().x + adjustement.x, this.getLocation().y + adjustement.y));
            }
        }
    }

    private boolean finished(Point point) {
        boolean y;
        boolean x = this.figure.getPoints().getFirstPoint().x + 15 > point.x && this.figure.getPoints().getFirstPoint().x - 15 < point.x;
        boolean bl = y = this.figure.getPoints().getFirstPoint().y + 15 > point.y && this.figure.getPoints().getFirstPoint().y - 15 < point.y;
        return x && y && this.figure.getPoints().size() >= 3;
    }

    private Point getAdjustement() {
        if (!this.isGeo()) {
            int selectionVertical = ((FigureCanvas)this.getCurrentViewer().getControl()).getVerticalBar().getSelection();
            int selectionHorizontal = ((FigureCanvas)this.getCurrentViewer().getControl()).getHorizontalBar().getSelection();
            return new Point(selectionHorizontal, selectionVertical);
        }
        Viewport viewport = (Viewport)((CustomScalableFreeformRootEditPart)this.getCurrentViewer().getRootEditPart()).getFigure();
        Dimension viewPortSize = viewport.getSize();
        return new Point(-viewPortSize.width / 2, -viewPortSize.height / 2);
    }

    private boolean isGeo() {
        if (this.getTargetEditPart() == null) {
            return false;
        }
        PropertyDescriptor geo = PropertyDescriptor.getPropertyDescriptor((String)"isGeo");
        if (geo == null) {
            return false;
        }
        INodeRelation relation = (INodeRelation)this.getTargetEditPart().getModel();
        return (Boolean)relation.getTarget().getProperty(geo);
    }
}

