/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls;

import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.gef.CustomEditDomain;
import com.centreon.studio.client.gef.CustomZoomManager;
import com.centreon.studio.client.gef.EditPartFactories;
import com.centreon.studio.client.gef.editparts.ANodeRelationConnectionEditPart;
import com.centreon.studio.client.gef.editparts.ANodeRelationGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.CustomScalableFreeformRootEditPart;
import com.centreon.studio.client.gef.editparts.DefaultInputGraphicalEditPart;
import com.centreon.studio.client.gef.editparts.INodeEditPart;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.actions.zoom.IZoomable;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.model.ui.contributionmanagers.IPosProvider;
import com.centreon.studio.client.model.ui.controls.INodeControl;
import com.centreon.studio.client.model.ui.controls.impl.listeners.ActionSetDescriptorListener;
import com.centreon.studio.client.model.ui.dnd.drop.INodeDropTargetListener;
import com.centreon.studio.client.model.ui.dnd.drop.NodeDropTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public final class NodeGraphicalViewer
implements INodeControl<Control>,
ISelectionChangedListener,
IRepositoryListener,
MouseWheelListener,
TraverseListener,
DisposeListener,
MouseListener,
FocusListener,
IPosProvider,
IZoomable {
    private final IEclipseContext context;
    private final INodeRelation input;
    private ScrollingGraphicalViewer viewer;
    private CustomZoomManager zoomManager;
    private NodeDropTarget dropTarget;
    private Control control;
    private volatile boolean selectionEnabled = true;

    private static boolean check(int i, int end, boolean next) {
        return next ? i < end : i >= end;
    }

    private static void select(boolean next, INode input) {
        INodeRelation selection = input.getRepository().getSelection();
        List relations = input.getRelations(new TypeDescriptor[0]);
        int start = next ? 0 : relations.size() - 1;
        int end = next ? relations.size() : 0;
        int index = start;
        int i = start;
        while (NodeGraphicalViewer.check(i, end, next)) {
            INodeRelation relation = (INodeRelation)relations.get(i);
            if (relation.equals((Object)selection)) {
                index = i;
                break;
            }
            i += NodeGraphicalViewer.step(next);
        }
        if (next && (index += NodeGraphicalViewer.step(next)) > end - 1 || !next && index < 0) {
            index = start;
        }
        input.getRepository().setSelection(NodeGraphicalViewer.class, Arrays.asList((INodeRelation)relations.get(index)));
    }

    private static int step(boolean next) {
        return next ? 1 : -1;
    }

    public NodeGraphicalViewer(Composite parent, INode node, IEclipseContext context) {
        Assert.isNotNull((Object)node, (String)"node must not be null");
        this.context = context;
        this.createControl(parent);
        this.input = INodeUtils.findRelationForTarget((INode)node.getRepository(), (TypeDescriptor)node.getType(), (Long)node.getId(), (PropertyValue[])new PropertyValue[0]);
        Assert.isNotNull((Object)this.input, (String)("could not find relation for node " + node));
        this.input.getRepository().registerSelectionListener((IRepositoryListener)this);
        this.control.addDisposeListener((DisposeListener)this);
        this.viewer.setContents((Object)this.input);
        ((INodeEditPart)this.viewer.getContents()).refreshConnections();
    }

    public final void addDropTargetListener(INodeDropTargetListener listener) {
        if (this.dropTarget == null) {
            this.dropTarget = new NodeDropTarget(this.getControl(), 19);
        }
        listener.setDropTarget(this.input);
        this.dropTarget.addListener(listener);
    }

    public void enableTooltips(boolean enabled) {
        this.viewer.setProperty("tooltipActive", (Object)Boolean.toString(enabled));
    }

    public void focusGained(FocusEvent e) {
        IEclipseContext topContext = ContextUtils.getTopContext((IEclipseContext)this.context);
        topContext.set(GraphicalViewer.class, (Object)this.viewer);
        topContext.set(IZoomable.class, (Object)this);
    }

    public void focusLost(FocusEvent e) {
    }

    public Control getControl() {
        return this.control;
    }

    public double getDefaultZoom() {
        return this.zoomManager.getDefaultZoom();
    }

    public double getMaxZoom() {
        return this.zoomManager.getMaxZoom();
    }

    public double getMinZoom() {
        return this.zoomManager.getMinZoom();
    }

    public Pos getPos() {
        RootEditPart root = this.viewer.getRootEditPart();
        if (root instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalRoot = (GraphicalEditPart)root;
            Rectangle clientArea = graphicalRoot.getFigure().getClientArea();
            Point cursor = Display.getCurrent().getCursorLocation();
            Point relativeCursor = this.control.toControl(cursor);
            return Pos.create((double)(relativeCursor.x + clientArea.x), (double)(relativeCursor.y + clientArea.y));
        }
        return null;
    }

    public double getZoom() {
        return this.zoomManager.getZoom();
    }

    public double[] getZoomLevels() {
        return this.zoomManager.getZoomLevels();
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.keyCode == 9) {
            if (e.stateMask == 0) {
                NodeGraphicalViewer.select(true, this.input.getTarget());
            } else if (e.stateMask == SWT.MOD2) {
                NodeGraphicalViewer.select(false, this.input.getTarget());
            }
            e.doit = false;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (e.stateMask == SWT.MOD1) {
            if (e.count == 3) {
                this.zoomIn(e.x, e.y);
            } else if (e.count == -3) {
                this.zoomOut(e.x, e.y);
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.button == 2) {
            this.setZoom(e.x, e.y, this.getDefaultZoom());
        }
    }

    public void refresh() {
        this.viewer.getRootEditPart().refresh();
    }

    public void selectionChanged(Object source, IRepository repository) {
        if (source == this.viewer.getControl()) {
            return;
        }
        SWTUtils.getDisplay().syncExec(() -> {
            this.setSelectionEnabled(false);
            this.viewer.deselectAll();
            List selections = this.input.getRepository().getSelections();
            if (selections.isEmpty()) {
                this.setSelectionEnabled(true);
                return;
            }
            ArrayList<EditPart> selectedParts = new ArrayList<EditPart>(selections.size());
            for (INodeRelation selection : selections) {
                EditPart part = (EditPart)this.viewer.getEditPartRegistry().get(selection);
                if (part == null || !part.isSelectable()) continue;
                selectedParts.add(part);
            }
            this.viewer.getSelectionManager().setSelection((ISelection)new ListStructuredSelection(selectedParts));
            if (selectedParts.size() == 1) {
                this.viewer.reveal((EditPart)selectedParts.get(0));
            }
            this.setSelectionEnabled(true);
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isSelectionEnabled()) {
            return;
        }
        SWTUtils.getDisplay().syncExec(() -> {
            this.setSelectionEnabled(false);
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object[] selectedObjects = selection.toArray();
            ArrayList<INodeRelation> newSelections = new ArrayList<INodeRelation>(selection.size());
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                INodeRelation relation = null;
                if (selected instanceof ANodeRelationGraphicalEditPart) {
                    relation = ((ANodeRelationGraphicalEditPart)selected).getModel();
                } else if (selected instanceof DefaultInputGraphicalEditPart && selectedObjects.length == 1) {
                    relation = ((DefaultInputGraphicalEditPart)selected).getModel();
                } else if (selected instanceof ANodeRelationConnectionEditPart) {
                    relation = ((ANodeRelationConnectionEditPart)selected).getModel();
                }
                if (relation != null) {
                    newSelections.add(relation);
                }
                ++n2;
            }
            this.input.getRepository().setSelection((Object)this.viewer, newSelections);
            this.setSelectionEnabled(true);
        });
    }

    public final void setKeyActions(ActionSetDescriptor actionSet) {
        ActionSetDescriptorListener actionListener = new ActionSetDescriptorListener(actionSet);
        this.getControl().addKeyListener((KeyListener)actionListener);
        this.getControl().addMouseListener((MouseListener)actionListener);
    }

    public void setZoom(int x, int y, double zoom) {
        this.zoomManager.setZoom(x, y, zoom);
    }

    public void widgetDisposed(DisposeEvent e) {
        IEclipseContext topContext = ContextUtils.getTopContext((IEclipseContext)this.context);
        if (topContext.get(GraphicalViewer.class) == this.viewer) {
            topContext.remove(GraphicalViewer.class);
        }
        if (topContext.get(IZoomable.class) == this) {
            topContext.remove(IZoomable.class);
        }
        this.input.getRepository().unregisterSelectionListener((IRepositoryListener)this);
        this.viewer.getEditDomain().removeViewer((EditPartViewer)this.viewer);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.dropTarget = null;
    }

    public void zoomIn(int x, int y) {
        this.zoomManager.zoomIn(x, y);
    }

    public void zoomOut(int x, int y) {
        this.zoomManager.zoomOut(x, y);
    }

    private void createControl(Composite parent) {
        parent.setLayout((Layout)SWTUtils.createGridLayout((int)1, (boolean)true, (int)0, (int)0));
        CustomScalableFreeformRootEditPart root = new CustomScalableFreeformRootEditPart();
        this.zoomManager = root.getZoomManager();
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.setEditDomain((EditDomain)CustomEditDomain.getInstance());
        this.viewer.setEditPartFactory((EditPartFactory)EditPartFactories.INSTANCE);
        this.viewer.setProperty(IEclipseContext.class.getSimpleName(), (Object)this.context);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setRootEditPart((RootEditPart)root);
        this.control = this.viewer.createControl(parent);
        this.control.setBackground(SWTUtils.getSystemColor((int)1));
        this.control.setLayoutData((Object)SWTUtils.createGridDataFill());
        this.control.addMouseWheelListener((MouseWheelListener)this);
        this.control.addTraverseListener((TraverseListener)this);
        this.control.addMouseListener((MouseListener)this);
        if (this.context != null) {
            this.viewer.getControl().addFocusListener((FocusListener)this);
        }
    }

    private synchronized boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    private synchronized void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
    }

    private static class ListStructuredSelection
    implements IStructuredSelection {
        private final List<?> list;

        private ListStructuredSelection(List<?> list) {
            this.list = list;
        }

        public Object getFirstElement() {
            return this.list.indexOf(0);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator<?> iterator() {
            return this.list.iterator();
        }

        public int size() {
            return this.list.size();
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public List<?> toList() {
            return this.list;
        }
    }
}

