/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication;

import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.exception.ExceptionEventHandler;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationExceptionEventHandler
extends ExceptionEventHandler {
    private static final List<Class<?>> EXCEPTION_THAT_DISCONNECT_USER = new ArrayList(2);
    private static final List<String> PATTERN_THAT_DISCONNECT_USER = new ArrayList<String>(2);
    private static final String DISCONNECTED_BY_ANOTHER_USER_MESSAGE = "Disconnected by another user";
    private final BrokerEventManager eventManager;
    private String url;

    static {
        EXCEPTION_THAT_DISCONNECT_USER.add(SocketException.class);
        EXCEPTION_THAT_DISCONNECT_USER.add(ConnectException.class);
        PATTERN_THAT_DISCONNECT_USER.add("Invalid Session");
    }

    public AuthenticationExceptionEventHandler(BrokerEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void handleEvent(ExceptionEvent event) {
        if (event.getException() == null || this.url == null) {
            return;
        }
        Throwable ex = event.getException();
        while (ex != null) {
            boolean disconnectedByAnotherUser = DISCONNECTED_BY_ANOTHER_USER_MESSAGE.equals(ex.getMessage());
            if (disconnectedByAnotherUser) {
                SWTUtils.getDisplay().syncExec(() -> MessageDialogUtils.openError((String)AuthenticationMessages.disconnectedByAnotherUserMessage));
                break;
            }
            if (ex.getMessage() == null) {
                return;
            }
            boolean sameUrl = ex.getMessage().contains(this.url);
            boolean exceptionThatDisconnect = EXCEPTION_THAT_DISCONNECT_USER.contains(ex.getClass());
            boolean messageThatDisconnect = PATTERN_THAT_DISCONNECT_USER.contains(ex.getMessage());
            if (exceptionThatDisconnect && sameUrl || messageThatDisconnect) {
                this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.REQUEST_FORCED_LOGOUT));
                return;
            }
            ex = ex.getCause();
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

