/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.model.object;

import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.authentication.model.AuthenticationTypes;
import com.centreon.studio.client.model.node.ANode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public final class Server
extends ANode {
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_SSL_PORT = 8443;

    private static Collection<PropertyValue> toProperties(String label, String address, int port, String url, boolean useSecureConnexion) {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(5);
        properties.add(new PropertyValue(AObject.LABEL, (Object)label));
        properties.add(new PropertyValue(PropertyDescriptors.ADDRESS, (Object)address));
        properties.add(new PropertyValue(AuthenticationPropertyDescriptors.PORT, (Object)port));
        properties.add(new PropertyValue(AuthenticationPropertyDescriptors.URL, (Object)url));
        properties.add(new PropertyValue(AuthenticationPropertyDescriptors.USE_SSL, (Object)useSecureConnexion));
        return properties;
    }

    public Server(Long id, Collection<PropertyValue> properties, IRepository repository) {
        super(AuthenticationTypes.SERVER, id, properties, repository);
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)((String)this.getProperty(PropertyDescriptors.ADDRESS))) ? 1 : 0) != 0, (String)"address must not be null");
    }

    public Server(String label, String address, int port, String url, boolean useSecureConnexion, IRepository repository) {
        this(SequenceUtils.next(), Server.toProperties(label, address, port, url, useSecureConnexion), repository);
    }

    public String computeCompleteUrl() {
        return String.valueOf((Boolean)this.getProperty(AuthenticationPropertyDescriptors.USE_SSL) != false ? "https://" : "http://") + (String)this.getProperty(PropertyDescriptors.ADDRESS) + ":" + this.getProperty(AuthenticationPropertyDescriptors.PORT) + (String)this.getProperty(AuthenticationPropertyDescriptors.URL);
    }

    public String getLabel() {
        String label = super.getLabel();
        if (StringUtils.isNullEmptyOrBlank((String)label)) {
            label = "(" + (String)this.getProperty(PropertyDescriptors.ADDRESS) + ":" + this.getProperty(AuthenticationPropertyDescriptors.PORT) + ")";
        }
        return label;
    }
}

