/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.model.service.ws;

import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.cxf.WebServiceManager;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.update.UpdateEvent;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.utils.DateUtils;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.authentication.AuthenticationDto;
import com.centreon.studio.map.authenticationservice.AuthPortType;
import com.centreon.studio.map.authenticationservice.AuthenticateFault;
import com.centreon.studio.map.commons.PropertyDto;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

@Creatable
@Singleton
public final class AuthenticationWebService
extends AWebService<AuthPortType> {
    private final BrokerEventManager eventManager;

    @Inject
    public AuthenticationWebService(BrokerEventManager eventManager) {
        super("/centreon-studio/services/authentication?wsdl", AuthPortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
    }

    public ACLUser authenticate(String url, String login, String pwd) throws AuthenticateFault {
        boolean userCantConnect;
        this.init(url, null);
        StepTimeTracker counter = new StepTimeTracker("authenticate " + url + " login " + login);
        Version serverVersion = this.getServerVersion();
        boolean bl = userCantConnect = !this.canUserConnect(login, pwd);
        if (userCantConnect) {
            AuthenticationEvent loginRefusalEvent = new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_FAILED).setMessage(AuthenticationMessages.loginCanceled).setColor(StudioColor.YELLOW.toSWT());
            this.eventManager.async((StudioEvent)loginRefusalEvent);
            return null;
        }
        AuthenticationDto response = ((AuthPortType)this.service).authenticate(login, pwd);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
        if (!StringUtils.isNullEmptyOrBlank((String)response.getStudioSession())) {
            ACLUser user;
            String timezone;
            TimeZone tz;
            WebServiceManager.INSTANCE.init(url, response.getStudioSession());
            System.setProperty("mapboxToken", response.getMapboxToken());
            System.setProperty("serverVersion", response.getServerVersion());
            Collection properties = PropertiesMapper.dtoToProperties((List)response.getProperties(), (PropertyValue[])new PropertyValue[0]);
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.LOGIN, (Object)login));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.PWD, (Object)pwd));
            String address = System.getProperty("centreon.url");
            if (!StringUtils.isNullEmptyOrBlank((String)address)) {
                properties.add(new PropertyValue(PropertyDescriptors.ADDRESS, (Object)address));
            }
            if ((tz = TimeZone.getTimeZone(timezone = (String)(user = (ACLUser)NodeFactories.INSTANCE.create(ACLTypes.USER, Long.valueOf(response.getUserDto().getId()), properties, null)).getProperty(AuthenticationPropertyDescriptors.TIMEZONE))) != null) {
                TimeZone.setDefault(tz);
            }
            PropertyFormatter pf = PropertyFormatter.getPropetyFormatter(Date.class);
            Date licenseStartDate = (Date)user.getProperty(AuthenticationPropertyDescriptors.LICENSE_START_DATE);
            Date licenseEndDate = (Date)user.getProperty(AuthenticationPropertyDescriptors.LICENSE_END_DATE);
            System.setProperty(AuthenticationPropertyDescriptors.LICENSE_START_DATE.id, pf.toString((Object)licenseStartDate));
            System.setProperty(AuthenticationPropertyDescriptors.LICENSE_END_DATE.id, pf.toString((Object)licenseEndDate));
            this.eventManager.async((StudioEvent)new UpdateEvent(UpdateEvent.UpdateEventType.REQUEST_UPDATE, serverVersion, false));
            return user;
        }
        return null;
    }

    public Version getServerVersion() throws SOAPFaultException {
        String stringServerVersion = ((AuthPortType)this.service).getServerVersion();
        Version version = new Version(stringServerVersion);
        return version;
    }

    public void init(String url, String token) {
        super.init(url, token);
        if (this.isInit()) {
            Client client = ClientProxy.getClient((Object)this.service);
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy policy = conduit.getClient();
            policy.setReceiveTimeout(20000L);
            policy.setConnectionTimeout(10000L);
        }
    }

    private boolean canUserConnect(String login, String pwd) {
        block4: {
            boolean accountIsAlreadyConnected = ((AuthPortType)this.service).isAccountAlreadyConnected(login);
            if (accountIsAlreadyConnected) break block4;
            return true;
        }
        try {
            AuthenticationDto connectedAccount = ((AuthPortType)this.service).getConnectedAccountSession(login, pwd);
            String userAlias = AuthenticationWebService.retrievePropertyFromDTO(connectedAccount, "label");
            String sessionCreationTime = AuthenticationWebService.retrievePropertyFromDTO(connectedAccount, "sessionCreationTime");
            String sessionIpAddress = AuthenticationWebService.retrievePropertyFromDTO(connectedAccount, "sessionIpAddress");
            LocalDateTime sessionCreateDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(sessionCreationTime)), ZoneId.systemDefault());
            String sessionUptime = DateUtils.formatTimeInterval((LocalDateTime)sessionCreateDate, (LocalDateTime)LocalDateTime.now());
            String confirmationMessage = NLS.bind((String)AuthenticationMessages.logoutOtherUserConfirmation, (Object[])new Object[]{userAlias, sessionUptime, sessionIpAddress});
            boolean wantToDisconnectOtherUser = MessageDialogUtils.openConfirm((String)confirmationMessage);
            return wantToDisconnectOtherUser;
        }
        catch (AuthenticateFault e) {
            this.eventManager.async((StudioEvent)LogEvent.error(AuthenticationWebService.class, (String)e.getMessage(), (Object[])new Object[]{e}));
        }
        catch (SOAPFaultException sOAPFaultException) {}
        return true;
    }

    private static String retrievePropertyFromDTO(AuthenticationDto authenticationDto, String key) {
        String soughtValue = "";
        for (PropertyDto property : authenticationDto.getProperties()) {
            if (!key.equals(property.getKey())) continue;
            soughtValue = property.getValue();
            break;
        }
        return soughtValue;
    }
}

