/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.ui;

import com.centreon.studio.client.authentication.Activator;
import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.authentication.model.AuthenticationTypes;
import com.centreon.studio.client.authentication.model.repository.ProfileRepository;
import com.centreon.studio.client.authentication.model.repository.decorator.ProfileRepositoryDecorator;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.ComboField;
import com.centreon.studio.client.commons.jface.validation.field.impl.PasswordField;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.jface.validation.form.Form;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.MoveShellListener;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.update.StudioVersion;
import com.centreon.studio.client.events.update.UpdateEvent;
import com.centreon.studio.client.events.update.UpdateEventHandler;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.edit.EditNodeRelationAction;
import com.centreon.studio.client.model.ui.actions.edit.RemoveNodesAction;
import com.centreon.studio.client.model.ui.actions.edit.WizardCreateNodeRelationAction;
import com.centreon.studio.client.model.ui.controls.impl.NodeCombo;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.client.workbench.properties.MainView;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

@Creatable
@Singleton
public final class AuthenticationSplash
extends AuthenticationEventHandler
implements IRepositoryListener {
    private static final String SPLASH_IMAGE_NAME = "platform:/plugin/com.centreon.studio.client.authentication/img/splash.png";
    private final IEclipseContext context;
    private final MApplication application;
    private final BrokerEventManager eventManager;
    private final ProfileRepositoryDecorator profileRepository;
    private Shell shell;
    private Label stateLabel;
    private Button editButton;
    private Button validButton;
    private Button removeButton;
    private NodeCombo profileCombo;
    private TextField loginField;
    private TextField passwordField;
    private boolean connecting;
    UpdateEventHandler updateEventHandler;

    @Inject
    public AuthenticationSplash(ProfileRepositoryDecorator profileRepository, BrokerEventManager eventManager, MApplication application, IEclipseContext context) {
        this.profileRepository = profileRepository;
        this.eventManager = eventManager;
        this.application = application;
        this.context = context;
    }

    private void fillFields(INodeRelation relation) {
        if (relation != null) {
            this.loginField.setValue((Object)((String)relation.getTarget().getProperty(AuthenticationPropertyDescriptors.LOGIN)));
            this.passwordField.setValue((Object)((String)relation.getTarget().getProperty(AuthenticationPropertyDescriptors.PWD)));
        } else {
            this.loginField.setValue((Object)"");
            this.passwordField.setValue((Object)"");
        }
        this.profileCombo.relationsRemoved(null, null);
        this.removeButton.setEnabled(relation != null);
        this.editButton.setEnabled(relation != null);
    }

    private void initComponent() {
        Bundle bundle = Activator.getContext().getBundle();
        StudioVersion version = new StudioVersion(bundle.getVersion());
        Display display = SWTUtils.getDisplay();
        Monitor monitor = SWTUtils.getCursorMonitor();
        Rectangle bounds = monitor.getBounds();
        Image splashImage = SWTUtils.getImageFromUrl((String)SPLASH_IMAGE_NAME);
        int shellWidth = splashImage.getImageData().width;
        int shellHeight = splashImage.getImageData().height;
        int shellX = (display.getPrimaryMonitor().getBounds().width - shellWidth) / 2 + bounds.x;
        int shellY = (display.getPrimaryMonitor().getBounds().height - shellHeight) / 2 + bounds.y;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        this.shell = new Shell(display, 0);
        this.shell.setLayout((Layout)layout);
        this.shell.setBackgroundMode(1);
        this.shell.setBounds(shellX, shellY, shellWidth, shellHeight);
        this.shell.setText(AuthenticationMessages.messageWelcome);
        this.shell.setBackgroundImage(splashImage);
        this.shell.addDisposeListener(e -> splashImage.dispose());
        this.shell.addListener(31, e -> {
            if (e.detail == 2) {
                this.quit();
            }
        });
        new MoveShellListener(this.shell);
        GridData parentGridData = new GridData(1, 0x1000008, true, true);
        parentGridData.widthHint = 380;
        Composite parent = SWTUtils.createComposite((Composite)this.shell, (int)2, (boolean)false, (int)0, (int)10, (GridData)parentGridData);
        String text = version.getFullVersion();
        SWTUtils.createLabel((Composite)this.shell, (String)text).addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    MainView view = new MainView();
                    Shell shell = new Shell(SWTUtils.getDisplay());
                    shell.setSize(800, 600);
                    view.createPartControl((Composite)shell);
                    shell.open();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        Form form = new Form();
        SWTUtils.createLabel((Composite)parent, (String)AuthenticationMessages.labelProfile);
        GridData gridData2 = new GridData(4, 4, true, false);
        gridData2.widthHint = 300;
        Composite combParent = SWTUtils.createComposite((Composite)parent, (int)4, (boolean)false, (int)0, (int)5, (GridData)gridData2);
        this.profileCombo = new NodeCombo(combParent, (INode)this.profileRepository, new TypeDescriptor[]{AuthenticationTypes.PROFILE});
        new ComboField((Combo)this.profileCombo.getControl(), null, (IForm)form, ControlValidators.COMBO_NON_EMPTY_VALIDATOR);
        WizardCreateNodeRelationAction createAction = new WizardCreateNodeRelationAction((IRepository)this.profileRepository, this.context, AuthenticationTypes.PROFILE, null, true){

            protected INode getParent() {
                return AuthenticationSplash.this.profileRepository;
            }
        };
        Button createButton = SWTUtils.createButtonPush((Composite)combParent, (int)0x1000008, (int)0x1000000, (Image)createAction.getImageDescriptor().createImage(), (SelectionListener)new SelectionAdapter((StudioAction)createAction){
            private final /* synthetic */ StudioAction val$createAction;
            {
                this.val$createAction = studioAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$createAction.run();
                AuthenticationSplash.this.validButton.setFocus();
            }
        });
        createButton.setData("org.eclipse.swtbot.widget.key", (Object)"createProfileButton");
        EditNodeRelationAction editAction = new EditNodeRelationAction((IRepository)this.profileRepository, this.context, false);
        this.editButton = SWTUtils.createButtonPush((Composite)combParent, (int)0x1000008, (int)0x1000000, (Image)editAction.getImageDescriptor().createImage(), (SelectionListener)new SelectionAdapter((StudioAction)editAction){
            private final /* synthetic */ StudioAction val$editAction;
            {
                this.val$editAction = studioAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$editAction.run();
                AuthenticationSplash.this.selectionChanged(null, (IRepository)AuthenticationSplash.this.profileRepository);
                AuthenticationSplash.this.validButton.setFocus();
            }
        });
        this.editButton.setData("org.eclipse.swtbot.widget.key", (Object)"editProfileButton");
        RemoveNodesAction removeAction = new RemoveNodesAction((IRepository)this.profileRepository, true, true, true);
        this.removeButton = SWTUtils.createButtonPush((Composite)combParent, (int)0x1000008, (int)0x1000000, (Image)removeAction.getImageDescriptor().createImage(), (SelectionListener)new SelectionAdapter((StudioAction)removeAction){
            private final /* synthetic */ StudioAction val$removeAction;
            {
                this.val$removeAction = studioAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$removeAction.run();
            }
        });
        this.removeButton.setData("org.eclipse.swtbot.widget.key", (Object)"removeProfileButton");
        this.loginField = new TextField(SWTUtils.createText((Composite)parent), AuthenticationMessages.labelLogin, "", (IForm)form, ControlValidators.TEXT_NON_EMPTY_VALIDATOR);
        this.passwordField = new PasswordField(SWTUtils.createPassword((Composite)parent), AuthenticationMessages.labelPassword, "", (IForm)form, ControlValidators.TEXT_NON_EMPTY_VALIDATOR);
        SWTUtils.createSpanner((Composite)parent, (int)1, (int)1);
        GridData gridData3 = new GridData(4, 4, true, false);
        gridData3.widthHint = 300;
        gridData3.heightHint = 30;
        this.stateLabel = SWTUtils.createLabel((Composite)parent, (String)"");
        this.stateLabel.setLayoutData((Object)gridData3);
        SWTUtils.createSpanner((Composite)parent, (int)1, (int)0);
        Composite compoButtons = SWTUtils.createComposite((Composite)parent, (int)2, (boolean)false, (int)0, (int)5, (GridData)new GridData(0x1000008, 1, false, false));
        this.validButton = SWTUtils.createButtonDefault((Composite)compoButtons, (int)4, (int)1, (String)CommonsMessages.keywordOk, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationSplash.this.sendLoginEvent();
            }
        });
        this.validButton.setData("org.eclipse.swtbot.widget.key", (Object)"validButton");
        form.registerValidationTrackingControl((Control)this.validButton);
        form.registerValidationTrackingRunnable(() -> this.validButton.setEnabled(!this.connecting));
        this.fillFields(this.profileRepository.getSelection());
        Button quitButton = SWTUtils.createButtonPush((Composite)compoButtons, (int)4, (int)1, (String)CommonsMessages.keywordQuit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationSplash.this.quit();
            }
        });
        quitButton.setData("org.eclipse.swtbot.widget.key", (Object)"quitButton");
    }

    private void initListeners() {
        this.profileRepository.registerSelectionListener(this);
        this.eventManager.subscribe("studio/authentication", false, (StudioEventHandler)this);
        this.updateEventHandler = new UpdateEventHandler(){

            public void handleEvent(UpdateEvent event) {
                if (UpdateEvent.UpdateEventType.EXECUTE_UPDATE.equals((Object)event.getEventType())) {
                    SWTUtils.getDisplay().syncExec(() -> AuthenticationSplash.this.setState(AuthenticationMessages.updateInProgress, StudioColor.YELLOW.toSWT()));
                }
            }
        };
        this.eventManager.subscribe("studio/update", false, (StudioEventHandler)this.updateEventHandler);
    }

    protected void loggedFail() {
        String message = StringUtils.isNullEmptyOrBlank((String)this.lastEvent.getMessage()) ? "" : this.lastEvent.getMessage();
        Color messageColor = this.lastEvent.getColor();
        this.setState(message, messageColor != null ? messageColor : StudioColor.RED.toSWT());
        this.connecting = false;
    }

    protected void loggedIn() {
        this.connecting = false;
        this.eventManager.unsubscribe((StudioEventHandler)this.updateEventHandler);
        this.shell.close();
        this.setWindowsVisibleAndOnTop(true, this.lastEvent.getProfile().getLabel());
    }

    protected void loggedOut() {
        this.connecting = false;
        SWTUtils.getDisplay().asyncExec(() -> this.open());
    }

    public void open() {
        this.initComponent();
        this.setWindowsVisibleAndOnTop(false, "");
        this.shell.setDefaultButton(this.validButton);
        this.shell.forceActive();
        this.shell.open();
        Display display = SWTUtils.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.initListeners();
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.unsubscribe((StudioEventHandler)this.updateEventHandler);
        this.profileRepository.unregisterSelectionListener(this);
    }

    private void quit() {
        try {
            ProfileRepository undecoratedRepository = (ProfileRepository)((Object)this.profileRepository.adapt(ProfileRepository.class));
            if (undecoratedRepository != null) {
                undecoratedRepository.save();
            }
        }
        catch (IOException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            MessageDialogUtils.openError((String)AuthenticationMessages.errorSaveProfiles);
        }
        System.exit(0);
    }

    public void selectionChanged(Object source, IRepository repository) {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.fillFields(repository.getSelection());
        }
    }

    private void sendLoginEvent() {
        if (this.connecting) {
            return;
        }
        this.connecting = true;
        INodeRelation selection = ((IRepository)this.profileRepository.adapt(IRepository.class)).getSelection();
        this.setState(AuthenticationMessages.keywordConnecting, StudioColor.BLUE.toSWT());
        this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.DO_LOGIN).setProfile(selection.getTarget()).setPwd(this.passwordField.getValue()).setLogin(this.loginField.getValue()));
        selection.getTarget().addPropertyValue(AuthenticationPropertyDescriptors.LAST_CONNEXION, (Object)System.currentTimeMillis());
    }

    private void setState(String text, Color color) {
        if (this.stateLabel.isDisposed()) {
            return;
        }
        this.stateLabel.setText(text);
        this.stateLabel.setToolTipText(text);
        this.stateLabel.setForeground(color);
        this.stateLabel.getParent().layout();
    }

    private void setWindowsVisibleAndOnTop(boolean visible, String message) {
        for (MWindow window : this.application.getChildren()) {
            Shell windowShell;
            window.setVisible(visible);
            window.setOnTop(visible);
            if (visible && (windowShell = (Shell)window.getWidget()) != null && !windowShell.isDisposed()) {
                windowShell.forceFocus();
            }
            if (!StringUtils.isNullEmptyOrBlank((String)message)) {
                window.getProperties().put(AObject.LABEL.id, window.getLabel());
                window.setLabel(String.valueOf(window.getLabel()) + " - " + message);
                continue;
            }
            String label = (String)window.getProperties().get(AObject.LABEL.id);
            if (StringUtils.isNullEmptyOrBlank((String)label)) continue;
            window.setLabel(label);
        }
    }
}

