/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.ui.wizard;

import com.centreon.studio.client.authentication.CustomProxySelector;
import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.authentication.model.AuthenticationTypes;
import com.centreon.studio.client.authentication.model.service.ws.AuthenticationWebService;
import com.centreon.studio.client.authentication.model.service.ws.DisconnectionWebService;
import com.centreon.studio.client.commons.Scheduler;
import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.CheckField;
import com.centreon.studio.client.commons.jface.validation.field.impl.IntegerTextField;
import com.centreon.studio.client.commons.jface.validation.field.impl.PasswordField;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.jface.validation.form.Form;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class ProfileWizardPage
extends CustomWizardPage {
    private final AuthenticationWebService authenticationWebService;
    private final DisconnectionWebService disconnectionWebService;
    private final BrokerEventManager eventManager;
    private final Scheduler scheduler;
    private TextField loginTextField;
    private TextField serverUrlTextField;
    private TextField proxyLoginTextField;
    private TextField proxyAddressTextField;
    private TextField serverAddressTextField;
    private CheckField useSslCheckField;
    private CheckField proxyServerCheckField;
    private CheckField proxyInternetCheckField;
    private IntegerTextField proxyPortIntegerTextField;
    private IntegerTextField serverPortIntegerTextField;
    private PasswordField passwordTextField;
    private PasswordField proxyPasswordField;
    private Button testButton;

    public ProfileWizardPage(Scheduler scheduler, AuthenticationWebService authenticationWebService, DisconnectionWebService disconnectionWebService, BrokerEventManager eventManager) {
        this(ProfileWizardPage.class.getSimpleName(), scheduler, authenticationWebService, disconnectionWebService, eventManager);
    }

    protected ProfileWizardPage(String pageName, Scheduler scheduler, AuthenticationWebService authenticationWebService, DisconnectionWebService disconnetionWebService, BrokerEventManager eventManager) {
        super(pageName);
        this.scheduler = scheduler;
        this.authenticationWebService = authenticationWebService;
        this.disconnectionWebService = disconnetionWebService;
        this.eventManager = eventManager;
    }

    public Composite customCreateControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)false, (int)5, (int)5);
        INode target = this.getInput().getTarget();
        Group profileGroup = SWTUtils.createGroup((Composite)composite, (String)AuthenticationTypes.PROFILE.getLabel(), (int)10, (int)2, (boolean)false, (GridData)SWTUtils.createGridDataHorizontalFill());
        Form form = new Form();
        this.serverAddressTextField = new TextField(SWTUtils.createText((Composite)profileGroup), PropertyDescriptors.ADDRESS.label, (String)target.getProperty(PropertyDescriptors.ADDRESS), (IForm)form, ControlValidators.TEXT_NON_EMPTY_VALIDATOR);
        this.loginTextField = new TextField(SWTUtils.createText((Composite)profileGroup), AuthenticationPropertyDescriptors.LOGIN.label, (String)target.getProperty(AuthenticationPropertyDescriptors.LOGIN), (IForm)form, null);
        this.passwordTextField = new PasswordField(SWTUtils.createPassword((Composite)profileGroup), AuthenticationPropertyDescriptors.PWD.label, (String)target.getProperty(AuthenticationPropertyDescriptors.PWD), (IForm)form, (ControlValidators.IControlValidator)new ControlValidators.AControlValidator<Text>(){

            public String getMessage() {
                return AuthenticationMessages.errorPasswordAndNoLogin;
            }

            public boolean validate(Text control) {
                if (!control.isEnabled()) {
                    return true;
                }
                return StringUtils.isNullEmptyOrBlank((String)ProfileWizardPage.this.passwordTextField.getValue()) || !StringUtils.isNullEmptyOrBlank((String)ProfileWizardPage.this.loginTextField.getValue());
            }
        });
        this.passwordTextField.setValue((String)target.getProperty(AuthenticationPropertyDescriptors.PWD));
        this.useSslCheckField = new CheckField(SWTUtils.createButtonCheck((Composite)profileGroup), AuthenticationPropertyDescriptors.USE_SSL.label, (Boolean)target.getProperty(AuthenticationPropertyDescriptors.USE_SSL), (IForm)form, null);
        ((Button)this.useSslCheckField.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ProfileWizardPage.this.serverPortIntegerTextField.setValue((Object)(ProfileWizardPage.this.useSslCheckField.getValue() != false ? 8443 : 8080));
            }
        });
        this.serverPortIntegerTextField = new IntegerTextField(SWTUtils.createText((Composite)profileGroup), AuthenticationPropertyDescriptors.PORT.label, (Integer)target.getProperty(AuthenticationPropertyDescriptors.PORT), (IForm)form, null);
        this.serverUrlTextField = new TextField(SWTUtils.createText((Composite)profileGroup), AuthenticationPropertyDescriptors.URL.label, (String)target.getProperty(AuthenticationPropertyDescriptors.URL), (IForm)form, null);
        Group proxyGroup = SWTUtils.createGroup((Composite)composite, (String)AuthenticationMessages.labelProxies, (int)10, (int)2, (boolean)false, (GridData)SWTUtils.createGridDataHorizontalFill());
        this.proxyAddressTextField = new TextField(SWTUtils.createText((Composite)proxyGroup), AuthenticationPropertyDescriptors.PROXY_ADDRESS.label, (String)target.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS), (IForm)form, null);
        this.proxyPortIntegerTextField = new IntegerTextField(SWTUtils.createText((Composite)proxyGroup), AuthenticationPropertyDescriptors.PROXY_PORT.label, (Integer)target.getProperty(AuthenticationPropertyDescriptors.PROXY_PORT), (IForm)form, null);
        this.proxyLoginTextField = new TextField(SWTUtils.createText((Composite)proxyGroup), AuthenticationPropertyDescriptors.PROXY_LOGIN.label, (String)target.getProperty(AuthenticationPropertyDescriptors.PROXY_LOGIN), (IForm)form, null);
        this.proxyPasswordField = new PasswordField(SWTUtils.createPassword((Composite)proxyGroup), AuthenticationPropertyDescriptors.PROXY_PASSWORD.label, (String)target.getProperty(AuthenticationPropertyDescriptors.PROXY_PASSWORD), (IForm)form, null);
        this.proxyInternetCheckField = new CheckField(SWTUtils.createButtonCheck((Composite)proxyGroup), AuthenticationPropertyDescriptors.USE_PROXY_INTERNET.label, (Boolean)target.getProperty(AuthenticationPropertyDescriptors.USE_PROXY_INTERNET), (IForm)form, null);
        this.proxyServerCheckField = new CheckField(SWTUtils.createButtonCheck((Composite)proxyGroup), AuthenticationPropertyDescriptors.USE_PROXY_SERVER.label, (Boolean)target.getProperty(AuthenticationPropertyDescriptors.USE_PROXY_SERVER), (IForm)form, null);
        this.testButton = SWTUtils.createButtonPush((Composite)composite, (int)0x1000008, (int)1, (String)CommonsMessages.keywordTest, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileWizardPage.this.testButton.setEnabled(false);
                ProfileWizardPage.this.test();
            }
        });
        return composite;
    }

    public Point getPageSize() {
        return new Point(500, 650);
    }

    protected boolean performFinish() {
        INode target = this.getInput().getTarget();
        target.addPropertyValue(AuthenticationPropertyDescriptors.LOGIN, (Object)this.loginTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PWD, (Object)this.passwordTextField.getValue());
        target.addPropertyValue(PropertyDescriptors.ADDRESS, (Object)this.serverAddressTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.URL, (Object)this.serverUrlTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PORT, (Object)this.serverPortIntegerTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.USE_SSL, (Object)this.useSslCheckField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PROXY_ADDRESS, (Object)this.proxyAddressTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PROXY_LOGIN, (Object)this.proxyLoginTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PROXY_PASSWORD, (Object)this.proxyPasswordField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.PROXY_PORT, (Object)this.proxyPortIntegerTextField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.USE_PROXY_INTERNET, (Object)this.proxyInternetCheckField.getValue());
        target.addPropertyValue(AuthenticationPropertyDescriptors.USE_PROXY_SERVER, (Object)this.proxyServerCheckField.getValue());
        return true;
    }

    protected void test() {
        this.performFinish();
        this.scheduler.execute(() -> {
            block6: {
                try {
                    try {
                        INode profile = this.getInput().getTarget();
                        if (StringUtils.isNullEmptyOrBlank((String)((String)profile.getProperty(PropertyDescriptors.ADDRESS)))) {
                            throw new Exception("No server selected");
                        }
                        CustomProxySelector.setConfiguration(profile);
                        String url = (String)profile.getProperty(AuthenticationPropertyDescriptors.COMPLETE_URL);
                        String login = (String)profile.getProperty(AuthenticationPropertyDescriptors.LOGIN);
                        String pwd = (String)profile.getProperty(AuthenticationPropertyDescriptors.PWD);
                        this.authenticationWebService.authenticate(url, login, pwd);
                        this.disconnectionWebService.disconnect();
                        this.eventManager.async((StudioEvent)new PopUpEvent().setTexts("Success", AuthenticationMessages.testProfileSuccess).setImagePath("platform:/plugin/com.centreon.studio.client.events/img/connected.png"));
                    }
                    catch (Exception e) {
                        this.eventManager.sync((StudioEvent)new ExceptionEvent((Throwable)new RuntimeException(e.getMessage())));
                        CustomProxySelector.disabledLast();
                        SWTUtils.getDisplay().syncExec(() -> {
                            if (!this.testButton.isDisposed()) {
                                this.testButton.setEnabled(true);
                            }
                        });
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    CustomProxySelector.disabledLast();
                    SWTUtils.getDisplay().syncExec(() -> {
                        if (!this.testButton.isDisposed()) {
                            this.testButton.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                CustomProxySelector.disabledLast();
                SWTUtils.getDisplay().syncExec(() -> {
                    if (!this.testButton.isDisposed()) {
                        this.testButton.setEnabled(true);
                    }
                });
            }
        });
    }
}

