/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.chart;

import com.centreon.studio.client.utils.StringUtils;
import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.core.runtime.Assert;

public final class LineData
implements Comparable<LineData> {
    private final boolean threshold;
    private final String unit;
    private final String label;
    private final ColorDefinition color;
    private final Collection<Double> values;

    public LineData(String label, String unit, ColorDefinition color, boolean threshold, Collection<Double> values) {
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)label) ? 1 : 0) != 0, (String)"label must not me null or empty");
        Assert.isTrue((values != null && !values.isEmpty() ? 1 : 0) != 0, (String)"values must not me null or empty");
        Assert.isNotNull((Object)color, (String)"color must not be null");
        this.threshold = threshold;
        this.values = values;
        this.label = label;
        this.color = color;
        this.unit = unit;
    }

    @Override
    public int compareTo(LineData o) {
        return this.label.compareTo(o.label);
    }

    public ColorDefinition getColor() {
        return this.color;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnit() {
        return this.unit;
    }

    public Collection<Double> getValues() {
        return this.values;
    }

    public boolean isThreshold() {
        return this.threshold;
    }
}

