/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.chart;

import com.centreon.studio.client.chart.PieData;
import com.centreon.studio.client.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.core.runtime.Assert;

public class PieChart
extends ChartWithoutAxesImpl {
    private final PieSeries series;
    private final SeriesDefinition baseSeriesDefintion;
    private final Series categorySeries;

    public PieChart() {
        this(Collections.emptyList(), 0, 0, false);
    }

    public PieChart(List<PieData> datas, int explosion, int innerRadius, boolean displayLabel) {
        Assert.isTrue((datas != null ? 1 : 0) != 0, (String)"data must not be null");
        this.initialize();
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        this.baseSeriesDefintion = SeriesDefinitionImpl.create();
        this.categorySeries = SeriesImpl.create();
        this.categorySeries.setStacked(true);
        this.baseSeriesDefintion.getSeries().add((Object)this.categorySeries);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        this.series = (PieSeries)PieSeriesImpl.create();
        this.series.setLabelPosition(Position.INSIDE_LITERAL);
        this.series.getLabel().getCaption().getFont().setName("Verdana");
        this.series.getLabel().getCaption().getFont().setSize(10.0f);
        this.series.getLabel().setVisible(displayLabel);
        this.series.setInnerRadius((double)innerRadius);
        this.series.setExplosion(explosion);
        seriesDefinition.getSeries().add((Object)this.series);
        this.baseSeriesDefintion.getSeriesDefinitions().add((Object)seriesDefinition);
        this.getSeriesDefinitions().add((Object)this.baseSeriesDefintion);
        this.setGridColumnCount(1);
        this.setDatas(datas);
    }

    public Double getInnerRadius() {
        return this.series.getInnerRadius();
    }

    public void setDatas(List<PieData> datas) {
        String[] labels = new String[datas.size()];
        Double[] values = new Double[datas.size()];
        Fill[] fills = new Fill[datas.size()];
        int i = 0;
        for (PieData data : datas) {
            labels[i] = data.getLabel();
            values[i] = data.getValue();
            fills[i] = data.getColor();
            ++i;
        }
        this.series.setDataSet((DataSet)NumberDataSetImpl.create((Object)values));
        this.categorySeries.setDataSet((DataSet)TextDataSetImpl.create((Object)labels));
        this.baseSeriesDefintion.getSeriesPalette().getEntries().clear();
        Fill[] fillArray = fills;
        int n = fills.length;
        int n2 = 0;
        while (n2 < n) {
            Fill element = fillArray[n2];
            this.baseSeriesDefintion.getSeriesPalette().getEntries().add((Object)element);
            ++n2;
        }
    }

    public void setDisplayLabels(boolean displayLabel) {
        this.series.getLabel().setVisible(displayLabel);
    }

    public void setExplosion(int value) {
        this.series.setExplosion(value);
    }

    public void setInnerRadius(Double value) {
        this.series.setInnerRadius(value.doubleValue());
    }

    public void setTitle(String title) {
        this.getTitle().getLabel().getCaption().setValue(title);
        this.getTitle().getLabel().getCaption().getFont().setSize(10.0f);
        this.getTitle().getLabel().getCaption().getFont().setName("Verdana");
        this.getTitle().setVisible(!StringUtils.isNullEmptyOrBlank((String)title));
    }
}

