/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.exceptions;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.exception.ExceptionEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.IPopUpRunnable;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.program.Program;

@Creatable
@Singleton
public final class ExceptionAddon
extends ExceptionEventHandler {
    private static final String INVALID_SESSION = "Invalid Session";
    private static final String KNOWN_BUG = "https://documentation.centreon.com/docs/centreon-map-4/en/latest/troubleshooter/index.html";
    private static final Map<String, String> PATTERN_TO_MESSAGE = new LinkedHashMap<String, String>();
    private static final Map<String, String> PATTERN_TO_URL;
    private final AuthenticationEventHandler authenticationEventHandler;
    private final BrokerEventManager eventManager;
    private final Set<String> filters = new TreeSet<String>();

    static {
        PATTERN_TO_MESSAGE.put("java.net.UnknownHostException", "Unknown address");
        PATTERN_TO_MESSAGE.put("java.net.MalformedURLException", "Invalid address");
        PATTERN_TO_MESSAGE.put("java.net.SocketTimeoutException", "Connection timeout");
        PATTERN_TO_MESSAGE.put("An invalid XML character", "Invalid XML character");
        PATTERN_TO_MESSAGE.put("Server returned HTTP response code: 403 for URL: https://api.mapbox.com/styles/v1/", "Invalid Map Box token");
        PATTERN_TO_URL = new LinkedHashMap<String, String>();
        PATTERN_TO_URL.put("Invalid Map Box token", "https://documentation.centreon.com/docs/centreon-map-4/en/latest/guide/exploitation/mapbox.html");
        PATTERN_TO_URL.put("ArrayIndexOutOfBoundsException", "");
        PATTERN_TO_URL.put("NullPointerException", "");
        PATTERN_TO_URL.put(INVALID_SESSION, "");
    }

    private static String getMessage(Throwable e, String fullStackCauseMessage) {
        int start;
        for (Map.Entry<String, String> entry : PATTERN_TO_MESSAGE.entrySet()) {
            if (!fullStackCauseMessage.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        String message = e.getLocalizedMessage();
        if (StringUtils.isNullEmptyOrBlank((String)message)) {
            message = e.toString();
        }
        start = (start = message.lastIndexOf(58)) == -1 ? 0 : start + 1;
        return message.substring(start);
    }

    private static String getUrl(String fullStackCauseMessage) {
        for (Map.Entry<String, String> entry : PATTERN_TO_URL.entrySet()) {
            if (!fullStackCauseMessage.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return KNOWN_BUG;
    }

    @Inject
    public ExceptionAddon(BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.authenticationEventHandler = new AuthenticationEventHandler(){

            protected void loggedIn() {
                ExceptionAddon.this.filters.remove(ExceptionAddon.INVALID_SESSION);
            }

            protected void requestLogout() {
                ExceptionAddon.this.filters.add(ExceptionAddon.INVALID_SESSION);
            }
        };
    }

    public void handleEvent(ExceptionEvent event) {
        if (!StringUtils.isNullEmptyOrBlank((String)event.getAction())) {
            if ("addPattern".equals(event.getAction())) {
                PATTERN_TO_MESSAGE.put(event.getContains(), event.getPrint());
            } else if ("removePattern".equals(event.getAction())) {
                PATTERN_TO_MESSAGE.remove(event.getContains());
            } else if ("addFilter".equals(event.getAction())) {
                this.filters.add(event.getFilter());
            } else if ("removeFilter".equals(event.getAction())) {
                this.filters.remove(event.getFilter());
            } else if ("registerException".equals(event.getAction())) {
                this.registerException(event);
            }
            return;
        }
        StringBuilder causeBuilder = new StringBuilder();
        Throwable ex = event.getException();
        while (ex != null) {
            causeBuilder.append(ex.toString()).append(" ");
            ex = ex.getCause();
        }
        String fullStackCauseMessage = causeBuilder.toString();
        for (String filter : this.filters) {
            if (!fullStackCauseMessage.contains(filter)) continue;
            this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Ignored because of filters : {}", (Object[])new Object[]{fullStackCauseMessage}));
            return;
        }
        String matchedMessage = ExceptionAddon.getMessage(event.getException(), fullStackCauseMessage);
        final String url = ExceptionAddon.getUrl(matchedMessage);
        PopUpEvent popupEvent = new PopUpEvent().setTexts("Error", event.getException().getMessage()).setImagePath("platform:/plugin/com.centreon.studio.client.events/img/error.png").setDuration(20L);
        if (!StringUtils.isNullEmptyOrBlank((String)url)) {
            popupEvent.setAction(new IPopUpRunnable(){

                public String getLabel() {
                    return "Known bugs";
                }

                public void run() {
                    Program.launch((String)url);
                }
            });
        }
        this.eventManager.async((StudioEvent)popupEvent);
        this.eventManager.async((StudioEvent)LogEvent.exception(((Object)((Object)this)).getClass(), (Throwable)event.getException()));
    }

    @PostConstruct
    public void postConstruct() {
        this.eventManager.subscribe("studio/exceptions", true, (StudioEventHandler)this);
        this.eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this.authenticationEventHandler);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Exception addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.unsubscribe((StudioEventHandler)this.authenticationEventHandler);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Exception addon destroyed", (Object[])new Object[0]));
    }

    private void registerException(ExceptionEvent event) {
        String previousValue = PATTERN_TO_URL.get(event.getContains());
        if (previousValue != null) {
            this.eventManager.async((StudioEvent)LogEvent.error(((Object)((Object)this)).getClass(), (String)"Exception already registered: {}", (Object[])new Object[]{previousValue}));
            return;
        }
        PATTERN_TO_URL.put(event.getContains(), event.getPrint());
    }
}

