/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.library;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.media.library.Activator;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.OsUtils;
import com.centreon.studio.client.utils.SequenceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.Bundle;

@Creatable
@Singleton
public class LibraryAddon
extends AuthenticationEventHandler {
    private static final String URL_FILE_PREFIX = OsUtils.isLinux() ? "file:" : "file:/";
    private final BrokerEventManager eventManager;
    private final IRepository repostiory;

    @Inject
    public LibraryAddon(MediaRepository repository, BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.repostiory = repository;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Media Library addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Media Library addon destroyed", (Object[])new Object[0]));
    }

    protected void loggedIn() {
        Bundle bundle = Activator.getContext().getBundle();
        URL bundleURL = bundle.getEntry("content/");
        try {
            URL folderURL = FileLocator.toFileURL((URL)bundleURL);
            File folder = new File(folderURL.toString().replaceFirst(URL_FILE_PREFIX, ""));
            if (folder.exists() && folder.isDirectory()) {
                ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>();
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    relations.add(this.registerDirectory(child, (INode)this.repostiory));
                    ++n2;
                }
                this.repostiory.addRelations(relations);
            }
        }
        catch (IOException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    private INodeRelation registerDirectory(File folder, INode parent) {
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(2);
        properties.add(new PropertyValue(AObject.LABEL, (Object)folder.getName()));
        properties.add(new PropertyValue(PropertyDescriptors.READ_ONLY, (Object)Boolean.TRUE));
        properties.add(new PropertyValue(PropertyDescriptors.DESCRIPTION, (Object)"Default library"));
        INode mediaGroup = NodeFactories.INSTANCE.create(MediaTypes.MEDIA_GROUP, SequenceUtils.next(), properties, parent.getRepository());
        INodeRelation groupRelation = NodeRelationFactories.INSTANCE.create(MediaTypes.MEDIA_RELATION, SequenceUtils.next(), parent, mediaGroup);
        File[] allFiles = folder.listFiles();
        ArrayList<File> files = new ArrayList<File>(allFiles.length);
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                if (file.isDirectory()) {
                    mediaGroup.addRelation(this.registerDirectory(file, mediaGroup));
                } else {
                    files.add(file);
                }
            }
            ++n2;
        }
        try {
            Collection relations = MediaUtils.importFiles((INode)mediaGroup, files);
            for (INodeRelation relation : relations) {
                relation.getTarget().addPropertyValue(PropertyDescriptors.READ_ONLY, (Object)Boolean.TRUE);
            }
            mediaGroup.addRelations(relations);
        }
        catch (IOException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        return groupRelation;
    }
}

