/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.node;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.CollectionsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;

public abstract class ANode
extends AObject
implements INode {
    private Map<TypeDescriptor, List<INodeRelation>> relations;
    private Collection<INodeRelationListener> listeners;

    protected ANode(TypeDescriptor type, Long id, Collection<PropertyValue> properties, IRepository repository) {
        super(type, id, properties, repository);
    }

    @Override
    public INodeRelation addRelation(INodeRelation relation) {
        Collection<INodeRelation> collection;
        if (relation != null && !(collection = this.addRelations(Arrays.asList(relation))).isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<INodeRelation> addRelations(Collection<INodeRelation> relations) {
        if (relations == null || relations.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.relations == null) {
            this.relations = CollectionsUtils.createMap((int)1, Collections.emptyList());
        }
        ArrayList<INodeRelation> addedRelations = new ArrayList<INodeRelation>(relations.size());
        for (INodeRelation relation : relations) {
            INodeRelation adaptedRelation = relation.adapt(INodeRelation.class);
            Assert.isTrue((adaptedRelation.getSource() == this ? 1 : 0) != 0, (String)"source must be this");
            List typedRelations = this.relations.get(adaptedRelation.getType());
            if (typedRelations == Collections.EMPTY_LIST) {
                typedRelations = CollectionsUtils.createList((int)1);
                this.relations.put(adaptedRelation.getType(), typedRelations);
            } else if (typedRelations.contains(adaptedRelation)) continue;
            typedRelations.add(adaptedRelation);
            addedRelations.add(adaptedRelation);
        }
        this.sendAddedEvent(addedRelations);
        return addedRelations;
    }

    @Override
    public List<INodeRelation> getRelations(TypeDescriptor ... descriptors) {
        if (this.relations == null) {
            return Collections.emptyList();
        }
        ArrayList<INodeRelation> allRelations = new ArrayList<INodeRelation>(0);
        if (descriptors != null && descriptors.length > 0) {
            HashSet<TypeDescriptor> hashSet = new HashSet<TypeDescriptor>(Arrays.asList(descriptors));
            for (TypeDescriptor descriptor : hashSet) {
                allRelations.addAll((Collection<INodeRelation>)this.relations.get(descriptor));
            }
        } else {
            for (Collection collection : this.relations.values()) {
                allRelations.addAll(collection);
            }
        }
        return allRelations;
    }

    @Override
    public void registerRelationsListener(INodeRelationListener nodeListener) {
        if (nodeListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<INodeRelationListener>();
        }
        this.listeners.add(nodeListener);
    }

    @Override
    public void removeRelation(INodeRelation relation) {
        if (relation != null) {
            this.removeRelations(Arrays.asList(relation));
        }
    }

    @Override
    public void removeRelations(Collection<INodeRelation> relations) {
        if (relations == null) {
            return;
        }
        if (this.relations == null) {
            relations.clear();
            return;
        }
        Iterator<INodeRelation> it = relations.iterator();
        while (it.hasNext()) {
            INodeRelation relation = it.next().adapt(INodeRelation.class);
            Assert.isTrue((relation.getSource() == this ? 1 : 0) != 0, (String)"source must be this");
            Collection typedRelations = this.relations.get(relation.getType());
            if (relations.equals(typedRelations)) {
                this.relations.remove(relation.getType());
                break;
            }
            if (!typedRelations.remove(relation)) {
                it.remove();
            }
            if (!typedRelations.isEmpty()) continue;
            this.relations.remove(relation.getType());
        }
        this.sendRemovedEvent(relations);
        if (this.getRepository() != null) {
            this.getRepository().removeFromSelection(relations);
        }
        if (this.relations != null && this.relations.isEmpty()) {
            this.relations = null;
        }
    }

    @Override
    public void unregisterRelationsListener(INodeRelationListener nodeListener) {
        if (this.listeners == null || nodeListener == null) {
            return;
        }
        this.listeners.remove(nodeListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void sendAddedEvent(Collection<INodeRelation> relations) {
        if (this.listeners != null && !relations.isEmpty()) {
            for (INodeRelationListener listener : this.listeners) {
                listener.relationsAdded(this, relations);
            }
        }
    }

    private void sendRemovedEvent(Collection<INodeRelation> relations) {
        if (this.listeners != null && !relations.isEmpty()) {
            for (INodeRelationListener listener : this.listeners) {
                listener.relationsRemoved(this, relations);
            }
        }
    }
}

