/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.node;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeFactory;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public enum NodeFactories implements INodeFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, INodeFactory> factories = new HashMap<TypeDescriptor, INodeFactory>(8);

    @Override
    public INode create(TypeDescriptor type, Long id, Collection<PropertyValue> properties, IRepository repository) {
        INodeFactory factory = this.factories.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(type, id, properties, repository);
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public void register(INodeFactory factory) {
        Assert.isTrue((factory != null && factory.getSupportedTypes() != null ? 1 : 0) != 0, (String)"factory and supported types must not be null");
        for (TypeDescriptor supportedType : factory.getSupportedTypes()) {
            this.factories.put(supportedType, factory);
        }
    }
}

