/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.node;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeFactory;
import com.centreon.studio.client.model.node.TriFunction;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NodeFactory
implements INodeFactory {
    private final Map<TypeDescriptor, TriFunction<Long, Collection<PropertyValue>, IRepository, INode>> constructors = new HashMap<TypeDescriptor, TriFunction<Long, Collection<PropertyValue>, IRepository, INode>>();

    @Override
    public INode create(TypeDescriptor type, Long id, Collection<PropertyValue> properties, IRepository repository) {
        return this.constructors.containsKey(type) ? this.constructors.get(type).apply(id, properties, repository) : null;
    }

    @Override
    public Collection<TypeDescriptor> getSupportedTypes() {
        return this.constructors.keySet();
    }

    protected Map<TypeDescriptor, TriFunction<Long, Collection<PropertyValue>, IRepository, INode>> getConstructors() {
        return Collections.unmodifiableMap(this.constructors);
    }

    protected boolean registerType(TypeDescriptor type, TriFunction<Long, Collection<PropertyValue>, IRepository, INode> function) {
        return this.constructors.put(type, function) == null;
    }
}

