/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.object;

import com.centreon.studio.client.model.messages.ModelMessages;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;

public abstract class AObject
implements IObject {
    public static final PropertyDescriptor<Long> ID = new PropertyDescriptor<Object>("id", "ID", Long.class, null, true);
    public static final PropertyDescriptor<TypeDescriptor> TYPE = new PropertyDescriptor<Object>("type", "Type", TypeDescriptor.class, null, true);
    public static final PropertyDescriptor<String> LABEL = new PropertyDescriptor<String>("label", ModelMessages.propertyLabel, String.class, "", false);
    private final TypeDescriptor type;
    private final Long id;
    private final int hashCode;
    private final IRepository repository;
    private final Map<PropertyDescriptor<?>, Object> properties;
    private Collection<IPropertiesListener> listeners;

    protected AObject(TypeDescriptor type, Long id, Collection<PropertyValue> properties, IRepository repository) {
        Assert.isNotNull((Object)id, (String)"id must not be null");
        Assert.isNotNull((Object)type, (String)"type must not be null");
        this.id = id;
        this.type = type;
        this.repository = repository == null ? null : repository.adapt(IRepository.class);
        this.properties = new HashMap(1);
        this.addPropertyValues(this.getDefaultPropertyValues());
        if (properties != null) {
            this.addPropertyValues(properties);
        }
        this.hashCode = this.computeHashCode();
    }

    @Override
    public final <A> A adapt(Class<A> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (A)this;
        }
        if (clazz == TypeDescriptor.class) {
            return (A)this.getType();
        }
        if (clazz == Long.class) {
            return (A)this.getId();
        }
        if (clazz == String.class) {
            return (A)this.getLabel();
        }
        if (clazz == IRepository.class) {
            return (A)this.getRepository();
        }
        return null;
    }

    @Override
    public final <T> void addPropertyValue(PropertyDescriptor<T> descriptor, T value) {
        this.addPropertyValues(Arrays.asList(new PropertyValue(descriptor, value)));
    }

    @Override
    public void addPropertyValues(Collection<PropertyValue> propertyValues) {
        HashSet<PropertyValue> modifiedValues = new HashSet<PropertyValue>(propertyValues.size());
        ArrayList descriptorsToRemove = new ArrayList(propertyValues.size());
        for (PropertyValue propertyValue : propertyValues) {
            if (propertyValue.getValue() == null || StringUtils.isNullEmptyOrBlank((String)propertyValue.getValue().toString())) {
                descriptorsToRemove.add(propertyValue.getProperty());
                continue;
            }
            Object modifiedValue = this.properties.put(propertyValue.getProperty(), propertyValue.getValue());
            if (Objects.equals(modifiedValue, propertyValue.getValue())) continue;
            modifiedValues.add(PropertyValue.unchecked(propertyValue.getProperty(), modifiedValue, propertyValue.getValue()));
            descriptorsToRemove.remove(propertyValue.getProperty());
        }
        for (PropertyDescriptor propertyDescriptor : descriptorsToRemove) {
            Object value = this.properties.remove(propertyDescriptor);
            if (value == null) continue;
            modifiedValues.add(PropertyValue.unchecked(propertyDescriptor, value, null));
        }
        if (!modifiedValues.isEmpty()) {
            this.sendEvent(modifiedValues);
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IObject)) {
            return false;
        }
        IObject other = (IObject)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        return Objects.equals(this.getType(), other.getType());
    }

    @Override
    public Collection<PropertyValue> getDefaultPropertyValues() {
        return new ArrayList<PropertyValue>();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.getProperty(LABEL);
    }

    @Override
    public <T> T getProperty(PropertyDescriptor<T> descriptor) {
        PropertyDescriptor<T> fallBack;
        Assert.isNotNull(descriptor, (String)"descriptor must not be null");
        if (descriptor == ID) {
            return (T)this.getId();
        }
        if (descriptor == TYPE) {
            return (T)this.getType();
        }
        Object value = this.properties.get(descriptor);
        if (value == null) {
            fallBack = descriptor.fallBack;
            while (value == null && fallBack != null) {
                value = this.properties.get(fallBack);
                fallBack = fallBack.fallBack;
            }
        }
        fallBack = descriptor;
        while (value == null && fallBack != null) {
            value = fallBack.defaulValue;
            fallBack = fallBack.fallBack;
        }
        return descriptor.clazz.cast(value);
    }

    @Override
    public Collection<PropertyValue> getPropertyValues() {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(this.properties.size());
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : this.properties.entrySet()) {
            values.add(PropertyValue.unchecked(entry.getKey(), entry.getValue()));
        }
        return values;
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public final TypeDescriptor getType() {
        return this.type;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final void registerPropertiesListener(IPropertiesListener objectListener) {
        if (objectListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IPropertiesListener>();
        }
        this.listeners.add(objectListener);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [type=");
        builder.append(this.getType());
        builder.append(", id=");
        builder.append(this.getId());
        builder.append(", label=");
        builder.append(this.getLabel());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public final void unregisterPropertiesListener(IPropertiesListener objectListener) {
        if (this.listeners == null || objectListener == null) {
            return;
        }
        this.listeners.remove(objectListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.getId().hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    private void sendEvent(Collection<PropertyValue> propertyValues) {
        if (this.listeners != null) {
            for (IPropertiesListener listener : this.listeners) {
                listener.propertiesChanged(this, propertyValues);
            }
        }
    }
}

