/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.object;

import com.centreon.studio.client.model.messages.ModelMessages;
import com.centreon.studio.client.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class TypeDescriptor {
    private static final Map<Integer, TypeDescriptor> TYPES = new HashMap<Integer, TypeDescriptor>(128);
    private final Integer id;
    private final String name;
    private final String label;
    private final String smallImage;
    private final String largeImage;
    private final boolean isLocal;

    public static TypeDescriptor getType(Integer id) {
        return TYPES.get(id);
    }

    public TypeDescriptor(Integer id, String name, String label, String smallImage, String largeImage, boolean isLocal) {
        Assert.isTrue((id != null ? 1 : 0) != 0, (String)"id must not be null");
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)name) ? 1 : 0) != 0, (String)"name must not be null or empty");
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)label) ? 1 : 0) != 0, (String)"label must not be null or empty");
        Assert.isTrue((TYPES.put(id, this) == null ? 1 : 0) != 0, (String)(id + ModelMessages.alreadyExists));
        this.id = id;
        this.name = name;
        this.label = label;
        this.isLocal = isLocal;
        this.smallImage = smallImage;
        this.largeImage = largeImage;
    }

    public TypeDescriptor(Integer id, String name, TypeDescriptor parent) {
        this(id, name, parent.label, parent.smallImage, parent.largeImage, parent.isLocal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        return this.id.equals(other.id);
    }

    public Integer getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLargeImage() {
        return this.largeImage;
    }

    public String getName() {
        return this.name;
    }

    public String getSmallImage() {
        return this.smallImage;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return this.getLabel();
    }
}

