/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.repository;

import com.centreon.studio.client.model.node.ANode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.utils.CollectionsUtils;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ARepository
extends ANode
implements IRepository {
    private final List<INodeRelation> selection = CollectionsUtils.createList((int)1);
    private Collection<IRepositoryListener> listeners;

    protected ARepository(TypeDescriptor type, String label) {
        super(type, SequenceUtils.next(), Arrays.asList(new PropertyValue(AObject.LABEL, label)), null);
    }

    @Override
    public void appendToSelection(Object source, Collection<? extends INodeRelation> selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        boolean modified = false;
        for (INodeRelation iNodeRelation : selection) {
            INodeRelation adapted = iNodeRelation.adapt(INodeRelation.class);
            if (this.selection.contains(adapted)) continue;
            this.selection.add(adapted);
            modified = true;
        }
        if (modified) {
            this.sendEvent(source);
        }
    }

    @Override
    public IRepository getRepository() {
        return this;
    }

    @Override
    public INodeRelation getSelection() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    @Override
    public List<INodeRelation> getSelections() {
        return Collections.unmodifiableList(this.selection);
    }

    @Override
    public void registerSelectionListener(IRepositoryListener repositoryListener) {
        if (repositoryListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IRepositoryListener>();
        }
        this.listeners.add(repositoryListener);
    }

    @Override
    public void removeFromSelection(Collection<? extends INodeRelation> selection) {
        if (selection == null || selection.isEmpty() || this.selection.isEmpty()) {
            return;
        }
        boolean modified = false;
        for (INodeRelation iNodeRelation : selection) {
            if (this.selection.remove(iNodeRelation)) {
                modified = true;
            }
            if (this.selection.isEmpty()) break;
        }
        if (modified) {
            this.sendEvent(null);
        }
    }

    @Override
    public void setSelection(Object source, Collection<? extends INodeRelation> selection) {
        if (selection != null && this.selection.size() == selection.size() && this.selection.containsAll(selection)) {
            return;
        }
        this.selection.clear();
        if (selection != null) {
            this.selection.addAll(selection);
        }
        this.sendEvent(source);
    }

    @Override
    public void unregisterSelectionListener(IRepositoryListener repositoryListener) {
        if (this.listeners == null || repositoryListener == null) {
            return;
        }
        this.listeners.remove(repositoryListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void sendEvent(Object source) {
        if (this.listeners != null) {
            for (IRepositoryListener listener : this.listeners) {
                listener.selectionChanged(source, this);
            }
        }
    }
}

