# Security Policy

Centreon takes the security of our software products seriously.

If you believe you have found a security vulnerability, please report it to us as described below.

## Reporting a Vulnerability

**Please do not report security vulnerabilities through public GitHub issues.**

Send an email to security@centreon.com. If possible, encrypt your message with our PGP key below.

You should receive a response within 48 hours. If for some reason you do not, please follow up via email to ensure we received your original message.

To help us better understand the nature and scope of the possible issue, please describe as much as you can:

* Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
* Full paths of source file(s) related to the manifestation of the issue
* The location of the affected source code (tag/branch/commit or direct URL)
* Any special configuration required to reproduce the issue
* Step-by-step instructions to reproduce the issue
* Proof-of-concept or exploit code (if possible)
* Impact of the issue, including how an attacker might exploit the issue

## PGP information

### Public key

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=YBvx
-----END PGP PUBLIC KEY BLOCK-----
```

| Tag | Value |
| -- | -- |
| ID | BEAF6EBF631106F9 |
| Type | RSA |
| Size | 4096 |
| Created | 2020-02-11 |
| Expires | 2022-01-13 |
| Cipher |AES-256|
| Fingerprint | C377 E9D5 2D5C 137D 3DD5 73B5 BEA F6EBF 6311 06F9 |

## Bug bounty

We don't have a bug bounty program but this is something we are thinking about.
