/*
** Copyright 2011-2012 Centreon
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
** For more information : contact@centreon.com
*/

#ifndef CCB_PROCESSING_STAT_VISITABLE_HH
#define CCB_PROCESSING_STAT_VISITABLE_HH

#include <nlohmann/json.hpp>

#include "com/centreon/broker/misc/processing_speed_computer.hh"
#include "com/centreon/broker/timestamp.hh"

namespace com::centreon::broker {

namespace processing {
constexpr unsigned idle_microsec_wait_idle_thread_delay = 100000;
/**
 *  @class stat_visitable stat_visitable.hh
 * "com/centreon/broker/processing/stat_visitable.hh"
 *  @brief Represent a processing thread that is visitable.
 */
class stat_visitable {
  std::string _last_error;
  timestamp _last_connection_attempt;
  timestamp _last_connection_success;
  misc::processing_speed_computer _event_processing_speed;
  std::atomic<char const*> _state;
  std::atomic<uint32_t> _queued_events;

 protected:
  const std::string _name;
  mutable std::mutex _stat_mutex;

  virtual uint32_t _get_queued_events() const = 0;
  virtual std::string const& _get_read_filters() const = 0;
  virtual std::string const& _get_write_filters() const = 0;
  virtual void _forward_statistic(nlohmann::json& tree);

 public:
  stat_visitable(std::string const& name = std::string());
  virtual ~stat_visitable() noexcept = default;
  stat_visitable(stat_visitable const& other) = delete;
  stat_visitable& operator=(stat_visitable const& other) = delete;

  std::string const& get_name() const;
  void set_last_error(std::string const& last_error);
  void set_state(char const* state);
  void set_queued_events(uint32_t);
  virtual void stats(nlohmann::json& tree);
  void set_last_connection_attempt(timestamp last_connection_attempt);
  void set_last_connection_success(timestamp last_connection_success);
  void tick(uint32_t events = 1);
};
}  // namespace processing

}

#endif  // !CCB_PROCESSING_STAT_VISITABLE_HH
