/**
 * Copyright 2022-2023 Centreon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 */

#ifndef CCB_BBDO_VERSION_HH
#define CCB_BBDO_VERSION_HH

namespace com::centreon::broker::bbdo {

union bbdo_version {
  struct {
#pragma pack(2)
    uint16_t patch;
    uint16_t minor_v;
    uint16_t major_v;
    uint16_t dummy = 0;
#pragma pack()
  };

  uint64_t total_version;

  bbdo_version() : total_version(0) {}

  bbdo_version(uint16_t maj, uint16_t min, uint16_t ptch)
      : patch(ptch), minor_v(min), major_v(maj) {}

  bool operator<(const bbdo_version& right) const {
    if (major_v != right.major_v) {
      return major_v < right.major_v;
    }
    if (minor_v != right.minor_v) {
      return minor_v < right.minor_v;
    }
    return patch < right.patch;
  }
};

}  // namespace com::centreon::broker::bbdo

#endif
