*** Settings ***
Documentation       Centreon Engine verify hostgroups inheritance.

Resource            ../resources/import.resource

Suite Setup         Ctn Clean Before Suite
Suite Teardown      Ctn Clean After Suite
Test Setup          Ctn Stop Processes
Test Teardown       Ctn Stop Engine Broker And Save Logs



*** Test Cases ***
NO_ENGINE_ENCRYPTION
    [Documentation]    Given an engine without configured encryption, we give him several macros and we expect to retrieve them in logs.
    ...    As engine is not ready to receive encrypted macros, is_encryption_ready must be equal to 0 in db
    [Tags]    engine    macros_decrypt    MON-158788
    Ctn Config Engine    ${1}    ${2}    ${10}
    Ctn Engine Config Set Value In Services    0    service_1    _CLEAR_MAC    clear_mac
    Ctn Engine Config Set Value In Services    0    service_1    _RAW_MAC    raw::raw_mac
    Ctn Engine Config Set Value In Services    0    service_1    _ENCRYPT_MAC    encrypt::encrypt_mac
    Ctn Engine Config Set Value    ${0}    log_level_commands    trace
    Ctn Engine Config Add Command    ${0}    with_mac_cmd   /bin/echo $_SERVICECLEAR_MAC$ $_SERVICERAW_MAC$ $_SERVICEENCRYPT_MAC$
    Ctn Engine Config Replace Value In Services    ${0}    service_1    check_command    with_mac_cmd

    Ctn Config Broker    module
    Ctn Config Broker    central
    Ctn Config Broker    rrd
    Ctn Config BBDO3    ${1}

    Ctn Clear Retention

    ${start}    Ctn Get Round Current Date
    Ctn Start Engine
    Ctn Start Broker
    Ctn Wait For Engine To Be Ready    ${start}    ${1}

    ${content}    Create List    clear_mac raw::raw_mac encrypt::encrypt_mac
    ${result}    Ctn Find In Log With Timeout    ${engineLog0}    ${start}    ${content}    60
    Should Be True    ${result}    "clear_mac raw::raw_mac encrypt::encrypt_mac" not found in logs.

    Connect To Database    pymysql    ${DBName}    ${DBUser}    ${DBPass}    ${DBHost}    ${DBPort}

    Check Row Count     SELECT instance_id FROM instances WHERE instance_id=1 AND running=1 AND is_encryption_ready=0    ==    1    retry_time_out=30s    retry_pause=2s

    Disconnect From Database    pymysql

ENGINE_ENCRYPTION_BAD_CONF
    [Documentation]    Given an engine with configured encryption, but without key and salt, 
    ...    we give him several macros and we expect to retrieve them in logs without decrypt.
    ...    As engine is not ready to receive encrypted macros, is_encryption_ready must be equal to 0 in db
    [Tags]    engine    macros_decrypt    MON-158788
    Ctn Config Engine    ${1}    ${2}    ${10}
    Ctn Engine Config Set Value In Services    0    service_1    _CLEAR_MAC    clear_mac
    Ctn Engine Config Set Value In Services    0    service_1    _RAW_MAC    raw::raw_mac
    Ctn Engine Config Set Value In Services    0    service_1    _ENCRYPT_MAC    encrypt::encrypt_mac
    Ctn Engine Config Set Value    ${0}    log_level_commands    trace
    Ctn Engine Config Add Command    ${0}    with_mac_cmd   /bin/echo $_SERVICECLEAR_MAC$ $_SERVICERAW_MAC$ $_SERVICEENCRYPT_MAC$
    Ctn Engine Config Replace Value In Services    ${0}    service_1    check_command    with_mac_cmd

    Ctn Config Broker    module
    Ctn Config Broker    central
    Ctn Config Broker    rrd
    Ctn Config BBDO3    ${1}

    Ctn Clear Retention
    Create File    /etc/centreon-engine/engine-context.json    " "

    ${start}    Ctn Get Round Current Date
    Ctn Start Engine
    Ctn Start Broker
    Ctn Wait For Engine To Be Ready    ${start}    ${1}
    
    ${content}    Create List    clear_mac raw::raw_mac encrypt::encrypt_mac
    ${result}    Ctn Find In Log With Timeout    ${engineLog0}    ${start}    ${content}    60
    Should Be True    ${result}    "clear_mac raw::raw_mac encrypt::encrypt_mac" not found in logs.
    
    Connect To Database    pymysql    ${DBName}    ${DBUser}    ${DBPass}    ${DBHost}    ${DBPort}

    Check Row Count     SELECT instance_id FROM instances WHERE instance_id=1 AND running=1 AND is_encryption_ready=0    ==    1    retry_time_out=30s    retry_pause=2s

    Disconnect From Database    pymysql

ENGINE_ENCRYPTION_GOOD_CONF
    [Documentation]    Given an engine with configured encryption, and key and salt, 
    ...    we give him several macros and we expect to retrieve them in logs without decrypt.
    ...    As engine is ready to receive encrypted macros, is_encryption_ready must be equal to 1 in db
    [Tags]    engine    macros_decrypt    MON-158788

    #we need broker to encode values
    Ctn Config Engine    ${1}    ${2}    ${10}
    Ctn Config Broker    central
    Ctn Config Broker    module
    Ctn Config Broker    rrd
    Ctn Config BBDO3    ${1}


    Ctn Broker Config Log    central    sql    trace
    Ctn Start Broker

    ${encrypted}    Ctn Aes Encrypt    51001    ${AppSecret}    ${Salt}    The content to encode
    log to console    Encrypted: ${encrypted}


    
    Create File    /etc/centreon-engine/engine-context.json   {"app_secret":"${AppSecret}","salt":"${Salt}"}


    Ctn Engine Config Set Value In Services    0    service_1    _CLEAR_MAC    clear_mac
    Ctn Engine Config Set Value In Services    0    service_1    _RAW_MAC    raw::raw_mac
    Ctn Engine Config Set Value In Services    0    service_1    _ENCRYPT_MAC    encrypt::${encrypted}
    Ctn Engine Config Set Value    ${0}    log_level_commands    trace
    Ctn Engine Config Add Command    ${0}    with_mac_cmd   /bin/echo $_SERVICECLEAR_MAC$ $_SERVICERAW_MAC$ $_SERVICEENCRYPT_MAC$
    Ctn Engine Config Replace Value In Services    ${0}    service_1    check_command    with_mac_cmd


    Ctn Clear Retention

    ${start}    Ctn Get Round Current Date
    Ctn Start Engine
    Ctn Wait For Engine To Be Ready    ${start}    ${1}

    Sleep    1s
    Remove File    /etc/centreon-engine/engine-context.json
    
    ${content}    Create List   clear_mac raw_mac The content to encode
    ${result}    Ctn Find In Log With Timeout    ${engineLog0}    ${start}    ${content}    60
    Should Be True    ${result}    "clear_mac raw_mac The content to encode" not found in logs.

    Connect To Database    pymysql    ${DBName}    ${DBUser}    ${DBPass}    ${DBHost}    ${DBPort}

    Check Row Count     SELECT instance_id FROM instances WHERE instance_id=1 AND running=1 AND is_encryption_ready=1    ==    1    retry_time_out=30s    retry_pause=2s

    Disconnect From Database    pymysql

BROKER_LUA_ENCRYPTION
    [Documentation]    Given an engine with configured encryption, and key and salt, 
    ...    cbmod and broker use a lua script that use encrypted credentials
    ...    we give it an encrypted macro that contains path to a lua output files and 
    ...    we expect that this file will becreated by lua.
    [Tags]    broker    macros_decrypt    MON-174126

    Remove File    /tmp/test-LUA.log
    Remove File    /tmp/output-central.txt
    Remove File    /tmp/output-cbmod.txt

    Ctn Config Engine    ${1}    ${1}    ${1}
    Ctn Config Broker    central
    Ctn Config Broker    module
    Ctn Config Broker    rrd
    Ctn Config BBDO3    1
    Ctn Broker Config Log    central    neb    trace
    Ctn Broker Config Log    central    sql    error
    Ctn Broker Config Log    central    lua    debug

    Create File    /etc/centreon-engine/engine-context.json   {"app_secret":"${AppSecret}","salt":"${Salt}"}

    ${new_content}    Catenate    SEPARATOR=\n
    ...    function init(params)
    ...        logFile = params['log-file']
    ...        broker_log:info(0, 'lua start test')
    ...    end
    ...    
    ...    function write(e)
    ...      local file,err = io.open(logFile, 'a')
    ...      if file == nil then
    ...        broker_log:info(3, "Couldn't open file: " .. err)
    ...      else
    ...        file:write("event receive")
    ...        file:close()
    ...      end
    ...      return true
    ...    end
    ...

    # Create the initial LUA script file
    Create File    /tmp/test-LUA.lua    ${new_content}

    ${encrypted}=    Set Variable    mCfbvFEBJzdIRS8+2vo7CoQxcEqOLQLr3PlVgXclU/SV8gsbV957Sg4nBfKYmZwJu1SkaZP007N9jYPPbzDX3dt4hKdZ4W9ktPlOPS7KgbOtmQxiBN6AyYNX3gZzMYMwAgqaUVwcdjS+5BxvgZvL7A==  # /tmp/output-cbmod.txt
    Ctn Broker Config Add Lua Output    central    test-LUA    /tmp/test-LUA.lua    {"name": "log-file", "type": "password", "value":"encrypt::${encrypted}"}

    ${encrypted}=    Set Variable    PyGtc0616AdGJxB81q7RCKSGXAkGv1ETtjKCKrtnR1e7NqXl+LXEfOlwnbeX1+XDexNr5HNhOpTJ58BIApeCFpsqY54biWFfiJaeF56ErvN2JaZxraRR21aHp36xCNWcIYaoLsP97giJ6jinbUbH/g==    #/tmp/output-cbmod.txt
    Ctn Broker Config Add Lua Output    module0    test-LUA    /tmp/test-LUA.lua    {"name": "log-file", "type": "password", "value":"encrypt::${encrypted}"}

    ${start}    Get Current Date
    Ctn Start Broker
    Ctn Start Engine
    Ctn Wait For Engine To Be Ready    ${start}    ${1}

    Wait Until Created    /tmp/output-central.txt    1min
    Wait Until Created    /tmp/output-cbmod.txt    10s


*** Variables ***
${Salt}        U2FsdA==
${AppSecret}   SGVsbG8gd29ybGQsIGRvZywgY2F0LCBwdXBwaWVzLgo=
