#!/bin/sh

set -e
[ "${DEBUG:-0}" = "1" ] && set -x

# Run each startup script located in BASEDIR.
# ls is required to ensure that the scripts are properly sorted by name.
BASEDIR="/usr/share/centreon/container.d"
for file in `ls $BASEDIR` ; do
  case "$file" in
    *_background*)
      # Execute background script and store PID
      . "$BASEDIR/$file" &
      echo $! >> /tmp/background_pids
      ;;
    *)
      if ! . "$BASEDIR/$file"; then
        echo "Error executing $file"
        exit 1
      fi
      ;;
  esac
done
