<?php

/*
 * Copyright 2005 - 2020 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */
declare(strict_types=1);

namespace Centreon\Domain\Monitoring\Serializer;

use JMS\Serializer\Exclusion\ExclusionStrategyInterface;
use JMS\Serializer\Metadata\ClassMetadata;
use JMS\Serializer\Metadata\PropertyMetadata;
use JMS\Serializer\Context;
use Centreon\Domain\Monitoring\Resource as ResourceEntity;

/**
 * Exclusion strategy for resource list to skip applying of SERIALIZER_GROUP_MAIN on the parent object
 *
 * @package Centreon\Domain\Monitoring
 */
class ResourceExclusionStrategy implements ExclusionStrategyInterface
{
    /**
     * {@inheritDoc}
     */
    public function shouldSkipClass(ClassMetadata $metadata, Context $navigatorContext): bool
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function shouldSkipProperty(PropertyMetadata $property, Context $navigatorContext): bool
    {
        if (
            $property->class === ResourceEntity::class
            && $navigatorContext->getDepth() > 1
            && (
                !is_array($property->groups)
                || (
                    is_array($property->groups)
                    && !in_array(ResourceEntity::SERIALIZER_GROUP_PARENT, $property->groups)
                )
            )
        ) {
            return true;
        }

        return false;
    }
}
