<?php

/*
 * Copyright 2005 - 2023 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Tag\RealTime\Application\Repository;

use Core\Security\AccessGroup\Domain\Model\AccessGroup;
use Core\Tag\RealTime\Domain\Model\Tag;

interface ReadTagRepositoryInterface
{
    /**
     * Find all tags.
     *
     * @param int $typeId
     *
     * @throws \Throwable
     *
     * @return Tag[]
     */
    public function findAllByTypeId(int $typeId): array;

    /**
     * Find all tags.
     *
     * @param int $typeId
     * @param AccessGroup[] $accessGroups
     *
     * @throws \Throwable
     *
     * @return Tag[]
     */
    public function findAllByTypeIdAndAccessGroups(int $typeId, array $accessGroups): array;

    /**
     * Find tags of type typeId linked to the resource (identified by id and parentId).
     *
     * @param int $id
     * @param int $parentId
     * @param int $typeId
     *
     * @throws \Throwable
     *
     * @return Tag[]
     */
    public function findAllByResourceAndTypeId(int $id, int $parentId, int $typeId): array;
}
