<?php
$help = array();

$help["hostgroup_name"] = dgettext(
    "help",
    "Name of the host group. It must be unique and cannot contain white spaces,"
    . " or special characters like ~!$%^&*\"|'<>?,()=."
);
$help["alias"] = dgettext(
    "help",
    "This directive is used to define is a longer name or description used to identify the host group." .
    "It is provided in order to allow you to more easily identify a particular host group."
);
$help["snmp_options"] = dgettext(
    "help",
    "The SNMP community and version specified here can be referenced in the check command by using " .
    "the \$_HOSTSNMPCOMMUNITY\$ and \$_HOSTSNMPVERSION\$ macros."
); // must be verified!

$help["members"] = dgettext(
    "help",
    "Hosts belonging to the group"
);
$help["hostgroup_members"] = dgettext(
    "help",
    "This optional directive can be used to include hosts from other host groups in this host group."
);

$help["notes"] = dgettext("help", "Define an optional string of notes pertaining to the host group.");
$help["notes_url"] = dgettext(
    "help",
    "Define an optional URL that can be used to provide more information about the host group. Any " .
    "valid URL can be used. This can be very useful if you want to make detailed information on the host group, " .
    "emergency contact methods, etc. available to other support staff."
);
$help["action_url"] = dgettext(
    "help",
    "Define an optional URL that can be used to provide more actions to be performed on the host group. " .
    "You will see the link to the action URL in the host group details."
);
$help["icon_image"] = dgettext(
    "help",
    "Define the image that should be associated with this host group here. This image will be displayed in " .
    "the various places. The image will look best if it is 40x40 pixels in size."
);
$help["icon_image_alt"] = dgettext(
    "help",
    "Define an optional string that is used in the alternative description of the icon image."
);
$help["statusmap_image"] = dgettext(
    "help",
    "Define an image that should be associated with this host group in the statusmap CGI in monitoring engine. " .
    "You can choose a JPEG, PNG, and GIF image. The GD2 image format is preferred, as other image formats must be " .
    "converted first when the statusmap image is generated. The image will look best if it is 40x40 pixels in size."
);

$help["geo_coords"] = dgettext(
    "help",
    "Geographic coordinates to allow Centreon MAP to plot the host group on a geographic view."
    . " Format: Latitude,Longitude. For example, Paris' coordinates are 48.51,2.20"
);

$help['hg_rrd_retention'] = dgettext(
    "help",
    "RRD retention duration of all the services that are in this host group. If service is in multiple host " .
    "groups, the highest retention value will be used."
);
$help['hg_comment'] = dgettext("help", "Comments on this host group.");
$help['hg_activate'] = dgettext("help", "Whether this host group is enabled.");
$help['resource_access_rules'] = dgettext('help', 'Resource access rule to which the host group should be linked');
