import { LinkHorizontal } from '@visx/shape';
import { HierarchyPointLink } from '@visx/hierarchy/lib/types';

import { useTheme } from '@mui/material';

import { TreeProps, Node, BaseProp } from './models';

interface Props<TData> extends Pick<TreeProps<TData>, 'treeLink'> {
  links: Array<HierarchyPointLink<Node<TData>>>;
}

const Links = <TData extends BaseProp>({
  links,
  treeLink
}: Props<TData>): Array<JSX.Element> => {
  const theme = useTheme();

  return links.map((link) => {
    const ancestorIds = link.target
      .ancestors()
      .map((ancestor) => ancestor.data.data.id);

    const descendantIds = link.target
      .descendants()
      .map((ancestor) => ancestor.data.data.id);

    const key = `${link.source.data.data.id}-${link.source.data.data.name}-${ancestorIds}_${link.target.data.data.id}-${link.target.data.data.name}-${descendantIds}`;

    return (
      <LinkHorizontal
        data={link}
        data-testid={`${link.source.data.data.id}_to_${link.target.data.data.id}`}
        fill="none"
        key={key}
        stroke={
          treeLink?.getStroke?.({
            source: link.source.data.data,
            target: link.target.data.data
          }) || theme.palette.text.primary
        }
        strokeDasharray={
          treeLink?.getStrokeDasharray?.({
            source: link.source.data.data,
            target: link.target.data.data
          }) || '0'
        }
        strokeOpacity={
          treeLink?.getStrokeOpacity?.({
            source: link.source.data.data,
            target: link.target.data.data
          }) || 1
        }
        strokeWidth={
          treeLink?.getStrokeWidth?.({
            source: link.source.data.data,
            target: link.target.data.data
          }) || '2'
        }
      />
    );
  });
};

export default Links;
