<?php
/*
 * Copyright 2005-2015 Centreon
 * Centreon is developped by : Julien Mathis and Romain Le Merlus under
 * GPL Licence 2.0.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation ; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see <http://www.gnu.org/licenses>.
 *
 * Linking this program statically or dynamically with other modules is making a
 * combined work based on this program. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this program give Centreon
 * permission to link this program with independent modules to produce an executable,
 * regardless of the license terms of these independent modules, and to copy and
 * distribute the resulting executable under terms of Centreon choice, provided that
 * Centreon also meet, for each linked independent module, the terms  and conditions
 * of the license of that module. An independent module is a module which is not
 * derived from this program. If you modify this program, you may extend this
 * exception to your version of the program, but you are not obliged to do so. If you
 * do not wish to do so, delete this exception statement from your version.
 *
 * For more information : contact@centreon.com
 *
 */

$help = array();

/*
 * Basic Settings
 */
$help["timeperiod_name"] = dgettext("help", "Define a short name to identify the time period.");
$help["alias"] = dgettext("help", "Use the alias as a longer name or description to identify the time period.");
$help["weekday"] = dgettext(
    "help",
    "The weekday directives are comma-delimited lists of time ranges that are \"valid\" times for a particular " .
    "day of the week. Each time range is in the form of HH:MM-HH:MM, where hours are specified on a 24 hour " .
    "clock. For example, 00:15-24:00 means 12:15am in the morning for this day until 12:00am midnight " .
    "(a 23 hour, 45 minute total time range). If you wish to exclude an entire day from the timeperiod, simply " .
    "do not include it in the timeperiod definition."
);
$help["exception"] = dgettext(
    "help",
    "You can specify several different types of exceptions to the standard rotating weekday schedule. " .
    "Exceptions can take a number of different forms including single days of a specific or generic month, " .
    "single weekdays in a month, or single calendar dates. You can also specify a range of days/dates and even " .
    "specify skip intervals to obtain functionality described by \"every 3 days between these dates\". " .
    "Weekdays and different types of exceptions all have different levels of precedence, so it is important " .
    "to understand how they can affect each other."
);

/*
 * Advanced Settings
 */
$help["include"] = dgettext("help", "This directive is used to specify other timeperiod used as a timeperiod model.");
$help["exclude"] = dgettext(
    "help",
    "This directive is used to specify other timeperiod definitions whose time ranges should be excluded " .
    "from this timeperiod."
);
