<?php

/*
 * Copyright 2005 - 2023 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Application\Common\UseCase;

use Symfony\Component\HttpFoundation\Response;

interface PresenterInterface
{
    /**
     * @param ResponseStatusInterface|null $responseStatus
     */
    public function setResponseStatus(?ResponseStatusInterface $responseStatus): void;

    /**
     * @return ResponseStatusInterface|null
     */
    public function getResponseStatus(): ?ResponseStatusInterface;

    /**
     * @param array<string, mixed> $responseHeaders
     */
    public function setResponseHeaders(array $responseHeaders): void;

    /**
     * @return array<string, mixed>
     */
    public function getResponseHeaders(): array;

    /**
     * @param mixed $data
     */
    public function present(mixed $data): void;

    /**
     * Return the response stored in the presenter.
     *
     * Useful for handle case where show is not called (e.g for a redirection)
     *
     * @return mixed
     */
    public function getPresentedData(): mixed;

    /**
     * @return Response
     */
    public function show(): Response;
}
