<?php

/*
 * Copyright 2005 - 2023 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types = 1);

namespace Core\ResourceAccess\Application\UseCase\FindRule;

final class FindRuleResponse
{
    public int $id = 0;

    public string $name = '';

    public ?string $description = null;

    public bool $isEnabled = true;

    public bool $applyToAllContacts = false;

    public bool $applyToAllContactGroups = false;

    /** @var array<int, array{id: int, alias: string}> */
    public array $contacts = [];

    /** @var array<int, array{id: int, name: string}> */
    public array $contactGroups = [];

    /** @var mixed[] */
    public array $datasetFilters = [];
}

