<?php

/*
 * Copyright 2005 - 2023 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\User\Infrastructure\API\FindUsers;

use Centreon\Domain\RequestParameters\Interfaces\RequestParametersInterface;
use Core\Application\Common\UseCase\AbstractPresenter;
use Core\Application\Common\UseCase\ResponseStatusInterface;
use Core\Infrastructure\Common\Presenter\PresenterFormatterInterface;
use Core\User\Application\UseCase\FindUsers\FindUsersPresenterInterface;
use Core\User\Application\UseCase\FindUsers\FindUsersResponse;
use Core\User\Application\UseCase\FindUsers\TinyUserDto;

class FindUsersPresenter extends AbstractPresenter implements FindUsersPresenterInterface
{
    public function __construct(
        private readonly RequestParametersInterface $requestParameters,
        protected PresenterFormatterInterface $presenterFormatter,
    ) {
        parent::__construct($presenterFormatter);
    }

    /**
     * @inheritDoc
     */
    public function presentResponse(ResponseStatusInterface|FindUsersResponse $response): void
    {
        if ($response instanceof ResponseStatusInterface) {
            $this->setResponseStatus($response);
        } else {
            $result = [];
            foreach ($response->users as $dto) {
                if ($dto instanceof TinyUserDto) {
                    $result[] = [
                        'id' => $dto->id,
                        'alias' => $dto->alias,
                    ];
                    continue;
                }
                $result[] = [
                    'id' => $dto->id,
                    'name' => $dto->name,
                    'alias' => $dto->alias,
                    'email' => $dto->email,
                    'is_admin' => $dto->isAdmin,
                ];
            }
            $this->present([
                'result' => $result,
                'meta' => $this->requestParameters->toArray(),
            ]);
        }
    }
}
