<?php
/**
 * Copyright 2005-2015 CENTREON
 * Centreon is developped by : Julien Mathis and Romain Le Merlus under
 * GPL Licence 2.0.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation ; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see <http://www.gnu.org/licenses>.
 *
 * Linking this program statically or dynamically with other modules is making a
 * combined work based on this program. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this program give CENTREON
 * permission to link this program with independent modules to produce an executable,
 * regardless of the license terms of these independent modules, and to copy and
 * distribute the resulting executable under terms of CENTREON choice, provided that
 * CENTREON also meet, for each linked independent module, the terms  and conditions
 * of the license of that module. An independent module is a module which is not
 * derived from this program. If you modify this program, you may extend this
 * exception to your version of the program, but you are not obliged to do so. If you
 * do not wish to do so, delete this exception statement from your version.
 *
 * For more information : command@centreon.com
 *
 */

namespace CentreonClapi;

class CentreonACLResources
{
    private $DB;

    public function __construct(\Pimple\Container $dependencyInjector)
    {
        $this->_DB = $dependencyInjector['configuration_db'];
    }

    public function getACLResourceID($name)
    {
        $request = 'SELECT acl_group_id FROM acl_groups WHERE acl_group_name LIKE :name';
        $stmt = $this->_DB->prepare($request);
        $stmt->bindValue(':name', $name, \PDO::PARAM_STR);
        $stmt->execute();
        $data = $stmt->fetch(\PDO::FETCH_ASSOC);
        if ($data && isset($data['acl_group_id'])) {
            return $data['acl_group_id'];
        }

        return 0;
    }

    public function addContact($contact_id, $aclid)
    {
        $deleteRequest = 'DELETE FROM acl_group_contacts_relations WHERE acl_group_id = :aclid AND contact_contact_id = :contact_id';
        $deleteStmt = $this->_DB->prepare($deleteRequest);
        $deleteStmt->bindValue(':aclid', $aclid, \PDO::PARAM_INT);
        $deleteStmt->bindValue(':contact_id', $contact_id, \PDO::PARAM_INT);
        $deleteStmt->execute();

        $insertRequest = 'INSERT INTO acl_group_contacts_relations (acl_group_id, contact_contact_id) VALUES (:aclid, :contact_id)';
        $insertStmt = $this->_DB->prepare($insertRequest);
        $insertStmt->bindValue(':aclid', $aclid, \PDO::PARAM_INT);
        $insertStmt->bindValue(':contact_id', $contact_id, \PDO::PARAM_INT);
        $insertStmt->execute();

        return 0;
    }

    public function delContact($contact_id, $aclid)
    {
        $deleteRequest = 'DELETE FROM acl_group_contacts_relations WHERE acl_group_id = :aclid AND contact_contact_id = :contact_id';
        $deleteStmt = $this->_DB->prepare($deleteRequest);
        $deleteStmt->bindValue(':aclid', $aclid, \PDO::PARAM_INT);
        $deleteStmt->bindValue(':contact_id', $contact_id, \PDO::PARAM_INT);
        $deleteStmt->execute();

        return 0;
    }

    public function updateACL()
    {
        $updateRequest = "UPDATE `acl_resources` SET `changed` = '1'";
        $updateStmt = $this->_DB->prepare($updateRequest);
        $updateStmt->execute();

        return 0;
    }
}
