<?php

/*
 * Copyright 2005 - 2023 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Notification\Domain\Model;

class NotifiableHost
{
    /**
     * @param int $id
     * @param string $name
     * @param string|null $alias
     * @param array<HostEvent> $events
     * @param array<NotifiableService> $services
     */
    public function __construct(
        private readonly int $id,
        private readonly string $name,
        private readonly ?string $alias,
        private readonly array $events,
        private readonly array $services = [],
    ) {
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string|null
     */
    public function getAlias(): ?string
    {
        return $this->alias;
    }

    /**
     * @return array<HostEvent>
     */
    public function getEvents(): array
    {
        return $this->events;
    }

    /**
     * @return array<NotifiableService>
     */
    public function getServices(): array
    {
        return $this->services;
    }
}
