<?php

/*
 * Copyright 2005-2020 Centreon
 * Centreon is developed by : Julien Mathis and Romain Le Merlus under
 * GPL Licence 2.0.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation ; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see <htcontact://www.gnu.org/licenses>.
 *
 * Linking this program statically or dynamically with other modules is making a
 * combined work based on this program. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this program give Centreon
 * permission to link this program with independent modules to produce an executable,
 * regardless of the license terms of these independent modules, and to copy and
 * distribute the resulting executable under terms of Centreon choice, provided that
 * Centreon also meet, for each linked independent module, the terms  and conditions
 * of the license of that module. An independent module is a module which is not
 * derived from this program. If you modify this program, you may extend this
 * exception to your version of the program, but you are not obliged to do so. If you
 * do not wish to do so, delete this exception statement from your version.
 *
 * For more information : contact@centreon.com
 *
 */

require_once _CENTREON_PATH_ . "/www/class/centreonDB.class.php";
require_once _CENTREON_PATH_ . "/www/class/centreonContactgroup.class.php";
require_once _CENTREON_PATH_ . "/www/class/centreonLDAP.class.php";
require_once __DIR__ . "/centreon_configuration_objects.class.php";

/**
 * Class
 *
 * @class CentreonConfigurationContactgroup
 */
class CentreonConfigurationContactgroup extends CentreonConfigurationObjects
{
    /**
     * CentreonConfigurationContactgroup constructor
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return array
     * @throws PDOException
     * @throws RestBadRequestException
     */
    public function getList()
    {
        global $centreon;

        if (isset($this->arguments['page_limit']) && isset($this->arguments['page'])) {
            if (
                !is_numeric($this->arguments['page'])
                || !is_numeric($this->arguments['page_limit'])
                || $this->arguments['page_limit'] < 1
            ) {
                throw new RestBadRequestException('Error, limit must be an integer greater than zero');
            }
            $limit = ($this->arguments['page'] - 1) * $this->arguments['page_limit'];
            $offset = $this->arguments['page_limit'];
            $range = $limit . ',' . $offset;
        } else {
            $range = '';
        }

        $filterContactgroup = [];
        $ldapFilter = '';
        if (isset($this->arguments['q'])) {
            $filterContactgroup['cg_name'] = ['LIKE', '%' . $this->arguments['q'] . '%'];
            $filterContactgroup['cg_alias'] = ['OR', 'LIKE', '%' . $this->arguments['q'] . '%'];
            $ldapFilter = $this->arguments['q'];
        }

        $cg = new CentreonContactgroup($this->pearDB);
        $acl = new CentreonACL($centreon->user->user_id);

        $aclCgs = $acl->getContactGroupAclConf(
            ['fields' => ['cg_id', 'cg_name', 'cg_type', 'ar_name'], 'get_row' => null, 'keys' => ['cg_id'], 'conditions' => $filterContactgroup, 'order' => ['cg_name'], 'pages' => $range, 'total' => true],
            false
        );


        $contactgroupList = [];
        foreach ($aclCgs['items'] as $id => $contactgroup) {
            // If we query local contactgroups and the contactgroup type is ldap, we skip it
            if (
                isset($this->arguments['type'])
                && ($this->arguments['type'] === 'local')
                && ($contactgroup['cg_type'] === 'ldap')
            ) {
                $aclCgs['total'] -= 1;
                continue;
            }
            $sText = $contactgroup['cg_name'];
            if ($contactgroup['cg_type'] == 'ldap') {
                $sText .= " (LDAP : " . $contactgroup['ar_name'] . ")";
            }
            $id = $contactgroup['cg_id'];
            $contactgroupList[] = ['id' => $id, 'text' => $sText];
        }

        # get Ldap contactgroups
        // If we don't query local contactgroups, we can return an array with ldap contactgroups
        if (! isset($this->arguments['type']) || $this->arguments['type'] !== 'local') {
            $ldapCgs = [];
            if (isset($this->arguments['page_limit'], $this->arguments['page'])) {
                $maxItem = $this->arguments['page_limit'] * $this->arguments['page'];
                if ($aclCgs['total'] <= $maxItem) {
                    $ldapCgs = $cg->getLdapContactgroups($ldapFilter);
                }
            } else {
                $ldapCgs = $cg->getLdapContactgroups($ldapFilter);
            }

            foreach ($ldapCgs as $key => $value) {
                $sTemp = $value;
                if (!$this->uniqueKey($sTemp, $contactgroupList)) {
                    $contactgroupList[] = ['id' => $key, 'text' => $value];
                }
            }
        }

        return ['items' => $contactgroupList, 'total' => $aclCgs['total']];
    }

    /**
     * @param $val
     * @param array $array
     *
     * @return bool
     */
    protected function uniqueKey($val, &$array)
    {

        if (!empty($val) && count($array) > 0) {
            foreach ($array as $key => $value) {
                if ($value['text'] == $val) {
                    return true;
                }
            }
        }
        return false;
    }
}
