<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

namespace Centreon\Tests\Infrastructure\FileManager;

use Centreon\Infrastructure\FileManager\File;
use PHPUnit\Framework\TestCase;

class FileTest extends TestCase
{
    public function testAll(): void
    {
        $data = [
            'name' => 'A.txt',
            'type' => 'B',
            'tmp_name' => 'C',
            'error' => 0,
            'size' => 10,
        ];

        $entity = new File($data);

        $this->assertEquals($data['name'], $entity->getName());
        $this->assertEquals('txt', $entity->getExtension());
        $this->assertEquals($data['type'], $entity->getType());
        $this->assertEquals($data['tmp_name'], $entity->getTmpName());
        $this->assertEquals($data['error'], $entity->getError());
        $this->assertEquals($data['size'], $entity->getSize());
    }
}
