<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

namespace Centreon\Tests\Resources\Dependency;

use Centreon\ServiceProvider;
use Pimple\Container;

/**
 * Container provider for Centreon\Infrastructure\Service\CentreonDBManagerService
 *
 * @author Centreon
 * @version 1.0.0
 * @package centreon
 * @subpackage test
 */
trait CentreonDbManagerDependencyTrait
{
    /**
     * Set up DB manager service in container
     *
     * <code>
     * public function setUp()
     * {
     *     $container = new \Pimple\Container;
     *     $this->setUpCentreonDbManager($container);
     * }
     * </code>
     *
     * @param Container $container
     */
    public function setUpCentreonDbManager(Container $container): void
    {
        $container[ServiceProvider::CENTREON_DB_MANAGER]
            = loadDependencyInjector()[ServiceProvider::CENTREON_DB_MANAGER];
    }
}
