<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

namespace Centreon\Tests\Resources\Mock;

use Centreon\Application\DataRepresenter;
use Centreon\Infrastructure\Service\CentreonPaginationService;

/**
 * Mock of CentreonPaginationService service
 *
 * @author Centreon
 * @version 1.0.0
 * @package centreon
 * @subpackage test
 */
class CentreonPaginationServiceMock extends CentreonPaginationService
{
    /**
     * Disable service requirements
     */
    public function __construct()
    {
    }

    /**
     * {@inheritDoc}
     */
    public function getListing(): DataRepresenter\Listing
    {
        $result = [
            [
                'repository' => $this->repository,
                'dataRepresenter' => $this->dataRepresenter,
                'context' => $this->context,
                'limit' => $this->limit,
                'offset' => $this->offset,
            ],
        ];

        return new DataRepresenter\Listing($result);
    }
}
