<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Infrastructure\RealTime\Repository\Icon;

use Core\Domain\RealTime\Model\Icon;
use Core\Infrastructure\RealTime\Repository\Host\DbHostFactory;
use Core\Infrastructure\RealTime\Repository\Service\DbServiceFactory;

/**
 * @phpstan-import-type _dataHost from DbHostFactory
 * @phpstan-import-type _dataService from DbServiceFactory
 */
class DbIconFactory
{
    /**
     * @param _dataHost|_dataService $data
     *
     * @return Icon|null
     */
    public static function createFromRecord(array $data): ?Icon
    {
        if (
            $data['icon_name'] === null
            && $data['icon_url'] === null
        ) {
            return null;
        }

        return (new Icon())
            ->setName($data['icon_name'])
            ->setUrl($data['icon_url']);
    }
}
