<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Platform\Infrastructure;

use Core\Platform\Domain\InstallationVerifierInterface;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

final class CentreonInstallationVerifier implements InstallationVerifierInterface
{
    public function __construct(
        #[Autowire(param: 'centreon_etc_path')]
        private readonly string $etcDirectory,
        #[Autowire(param: 'centreon_install_path')]
        private readonly string $installDirectory,
    ) {
    }

    public function isCentreonWebInstalled(): bool
    {
        return file_exists($this->etcDirectory . '/centreon.conf.php');
    }

    public function isCentreonWebInstallableOrUpgradable(): bool
    {
        return is_dir($this->installDirectory);
    }
}
