import { equals, isNil } from 'ramda';
import { makeStyles } from 'tss-react/mui';

import { Typography } from '@mui/material';
import { getCommandsWithArguments } from './utils';

const useStyles = makeStyles()((theme) => ({
  argument: {
    marginRight: theme.spacing(0.5)
  },
  argumentWithValue: {
    display: 'flex',
    marginLeft: theme.spacing(1)
  },
  primaryCommand: {
    fontWeight: 'bold'
  },
  pipedCommand: {
    display: 'flex',
    flexDirection: 'row'
  },
  secondaryCommand: {
    color: theme.palette.background.tooltip
  }
}));

interface Props {
  commandLine: string;
}

const CommandWithArguments = ({ commandLine }: Props): JSX.Element => {
  const { classes } = useStyles();

  const commands = getCommandsWithArguments(commandLine);

  return (
    <div>
      {commands.map(({ command, arguments: args }, index) => {
        return (
          <div key={command}>
            <div className={classes.pipedCommand}>
              {index > 0 && (
                <Typography
                  className={classes.secondaryCommand}
                  variant="body2"
                >
                  --
                </Typography>
              )}
              <Typography
                className={
                  !equals(index, 0)
                    ? classes.secondaryCommand
                    : classes.primaryCommand
                }
                variant="body2"
              >
                {command}
              </Typography>
            </div>
            {args.map(([argument, value]) => {
              return (
                <div className={classes.argumentWithValue} key={argument}>
                  <Typography
                    className={classes.argument}
                    color="textSecondary"
                    variant="body2"
                  >
                    {argument}
                  </Typography>
                  {!isNil(value) && (
                    <Typography variant="body2">{value}</Typography>
                  )}
                </div>
              );
            })}
          </div>
        );
      })}
    </div>
  );
};

export default CommandWithArguments;
